#!/bin/bash

# Get script directory
workdir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
# Get script name
script_name="$(basename "$0")"
# Get date
date=$(date '+%Y-%m-%d')
# Create directory if not exist in case Wget doesn't create it
mkdir -p "$workdir"/foalcon-advisory/img

# Abort if file on this day already exists
if [[ -f "$workdir/Index-"$date".html" ]]; then
	echo "File exists"
	exit
fi

# Function to check and install a Python package
install_package() {
    package=$1
    if ! python -c "import $package" &>/dev/null; then
        echo "Installing $package..."
        pip install $package
    fi
}

# Check and install the required packages
install_package webpage2html
install_package bs4
install_package termcolor
install_package requests
install_package lxml

# Use webpage2html to create a single HTML file
webpage2html -s https://fimfetch.net/foalcon-advisory > "$workdir/Index-"$date".html"

# Replace some things.
sed -i "s/let imgDir = '\/foalcon-advisory\/';/let imgDir = 'foalcon-advisory\/';/g" "$workdir/Index-"$date".html"

# Grep the linked images inside the html class tags, read each line by line and use Wget to download them
grep -oP 'data-src="\K[^"]+' "$workdir/Index-"$date".html" | sed 's/^/https:\/\/fimfetch.net\/foalcon-advisory\//' |
while read line; do
	wget --no-clobber "$line" --directory-prefix="$workdir"/foalcon-advisory/img --append-output="$workdir"/foalcon-advisory/wget.log
done

# This also can be done in less commands
# Replace some things
sed -i "s|$workdir/foalcon-advisory/img/||g" "$workdir/foalcon-advisory/wget.log"
# Remove duplicate lines without sorting the file
awk -i inplace '/^\s*?$/||!seen[$0]++' "$workdir/foalcon-advisory/wget.log"
# Remove empty lines ONLY of another emoty line follows, this leaves the space between the populated lines and makes it easier to read
sed -i '/^$/N;/^\n$/D' "$workdir/foalcon-advisory/wget.log"