https://raw.githubusercontent.com/derpibooru/chatbot/master/src/main.js?token=AJNg6LwwIATtXtBbjMnRLQ22mhvftwIbks5a9RQQwA%3D%3D


import * as Command                     from './commands.js';
import { DiscordAdapter, IRCAdapter }   from './adapters/all.js';
import { DiscordJS, fs, sqlite3, util } from './external.js'; // libraries
import { DerpiCable }                   from './actioncable.js';
import { allCommands }                  from './commands/all.js';
import { derpibooruClient }             from './derpibooru.js';
import { escapeMarkdown }               from './escape.js';

const readFileP = util.promisify(fs.readFile);

async function loadBots() {
  const defaultConfig = JSON.parse(await readFileP('config.json', 'utf8'));
  const localConfig   = JSON.parse(await readFileP('config.local.json', 'utf8'));
  const config = Object.assign({}, defaultConfig, localConfig);

  const Cable        = new DerpiCable(config.api_endpoint_hostname, `?key=${config.actioncable_key}`);
  const LivefeedHook = new DiscordJS.WebhookClient(config.Discord.livefeed_hook_id, config.Discord.livefeed_hook_token);
  const ModfeedHook  = new DiscordJS.WebhookClient(config.Discord.modfeed_hook_id, config.Discord.modfeed_hook_token);

  const bots = {};

  Cable.setReceiveCallback(async data => {
    const tazBot = bots.TazBot;

    if (data.modfeed) {
      ModfeedHook.send(escapeMarkdown(data.modfeed.replace(/(http[^\s]+)/g, '<$1>')));
      if (tazBot) {
        tazBot.client.say('#derpibooru-modfeed', data.modfeed);
      }
    }
    else if (data.livefeed) {
      LivefeedHook.send(escapeMarkdown(data.livefeed.replace(/(http[^\s]+)/g, '<$1>')));
      if (tazBot) {
        tazBot.client.say('#derpibooru-livefeed', data.livefeed);
      }
    }
  });

  Cable.connect();

  const Booru     = derpibooruClient(false);
  const SafeBooru = derpibooruClient(true);
  const DB        = new sqlite3.Database('quotes');

  DB.run('create table if not exists quotes (id integer, user text, message text, channel text, primary key (id));');

  /*
   * Aliases
   */
  Command.alias('a', 'appeal');
  Command.alias('c', 'count');
  Command.alias('h', 'help');
  Command.alias('i', 'image');
  Command.alias('p', 'pony');
  Command.alias('pf', 'printerfact');
  Command.alias('r', 'roll');
  Command.alias('q', 'quote');
  Command.alias('t', 'tag');
  Command.alias('tf', 'tagfight');
  Command.alias('tw', 'tagfight');
  Command.alias('appealban', 'appeal');
  Command.alias('banappeal', 'appeal');
  Command.alias('tagwar', 'tagfight');

  /*
   * Commands
   */

  const commands = allCommands(DB, Booru, SafeBooru);

  Command.register('help',         commands.help);
  Command.register('pony',         commands.pony,         0, '[search query]');
  Command.register('count',        commands.count,        0, '<tags>');
  Command.register('tag',          commands.count,        0, '<tag>');
  Command.register('tagfight',     commands.tagFight,     2, '<tag> <another tag>');
  Command.register('image',        commands.image,        1, '<image id>');
  Command.register('quote',        commands.quote,       -1, '<add|username|#channel> <username|text> [text]');
  Command.register('appeal',       commands.appeal,       0, '[action]');
  Command.register('nsfw-extreme', commands.nsfwExtreme,  1, '<on/off>');
  Command.register('roll',         commands.roll,         0, '[none]');
  Command.register('printerfact',  commands.printerFact,  0, '[none]');

  async function onMessage(msg) {
    if (msg.channel.channelType !== 'text' || msg.channel.name === 'livefeed' || msg.channel.name === 'modfeed') return;

    const message = msg.content;
    const command = Command.readCommand(message);

    if (command) {
      const result = Command.run(msg, command.toLowerCase(), message);

      if (result && result.error) {
        msg.reply(`this isn't quite right!\n${result.message}`);
      }
    }
    else if (message.match(/^bot\b/i)) {
      msg.reply('no u');
    }
    else if (message.match(/>>(\d+)/g)) {
      const ids = message.match(/>>(\d+)/g);

      if (ids[0]) {
        commands.imageStats(msg, ids[0].replace('>>', '')); // FIXME
      }
    }
  }

  config.Bots.forEach(bot => {
    if (!bot.enabled) return;
    let botObj;

    switch (bot.adapter) {
      case 'discord':
        botObj = new DiscordAdapter();
        break;
      case 'irc':
        botObj = new IRCAdapter();
        break;
      default:
        // do nothing
        break;
    }

    botObj.connect(bot.data);

    if (bot.receiveMessages) {
      botObj.onMessage = onMessage;
    }

    // Store the bot in case we need to access it later.
    bots[bot.id] = botObj;
  });
}

loadBots();