import sys

syscalls = {
	'open_file': None,
	'modify_sectors': None,
	'draw_rect': None,
}

variables = {
	'window_chain_head': None,
	'redraw': None,
	'memory_allocation_map': None,
}

if len(sys.argv) != 3:
	print(f'Usage: {sys.argv[0]} outfile infile', file=sys.stderr)
	sys.exit(1)

outfile = sys.argv[1]
infile = sys.argv[2]

with open(infile, 'r') as f:
	header = f.read()
header = f'; This is from {infile}\n' + header

mapfile = []
while True:
	try:
		line = input()
	except EOFError:
		break
	mapfile.append(line)

section = None
for line in mapfile:
	line = line.split()
	if len(line) == 3:
		address, _, name = line
		if name in syscalls:
			syscalls[name] = int(address, 16)
		if name in variables:
			variables[name] = int(address, 16)

header += f'\n;This was automatically generated\n'

for syscall, address in syscalls.items():
	if address is None:
		print(f'{sys.argv[0]}: Error: syscall {syscall} not found', file=sys.stderr)
		sys.exit(1)
	header += f'SYS_{syscall.upper()} equ 0x{address:x}\n'

header += '\n'

for variable, address in variables.items():
	if address is None:
		print(f'{sys.argv[0]}: Error: global {variable} not found', file=sys.stderr)
		sys.exit(1)
	header += f'GLOBAL_{variable.upper()} equ 0x{address:x}\n'

with open(outfile, 'w') as f:
	f.write(header)
