# PonyDOS

### What is PonyDOS?

PonyDOS is a hobby 512-byte operating system, designed for ponies like you!

### Is PonyDOS a DOS distribution?

No! PonyDOS uses its own 512-byte kernel, built from scratch.

### Screenshots

![PonyDOS in action](ponydos.png)
![PonyDOS viewing PonyDOS source code](ponydos-viewer.png)

### Building from scratch

To build PonyDOS from scratch, on an environment with `nasm` and `python3`,
run `make`. `make run` runs the floppy disk image `ponydos.img` with QEMU.
By default, `qemu-system-i386` is invoked. If you want to use a different
backend, use `make QEMU=<backend> run`.

### Build options

You can configure the build using build options passed to the build system using
the `BUILDOPTS` variable, e.g. `make BUILDOPTS='-DBLINKY'`. It is advised to run
`make clean` before changing the value of `BUILDOPTS`.

* `-DBLINKY` builds an image which restricts the number of colours to 8. This is
  for compatibility with BIOSs which use the highest bit of background colour to
  signal that a cell should blink.

### How do I contribute?

There is a model `hello.asm` file to demonstrate how best to use the
multitude of features the kernel provides. Build your own program on top–write
an assembler, an audio mixer, a `ponysay`, whatever your heart desires!–and
contact us to merge it in.

### Credits

This is a parody of [klange](https://github.com/klange)'s wonderful
[PonyOS](https://ponyos.org/). The creators of this project,
[CrazyEttin](https://ahti.space/~crazyettin/),
[nortti](https://ahti.space/~nortti), [shikhin](https://shikhin.in), and
[wolf](https://oriole.systems) hang out in `#offtopia` on
[libera.chat](https://libera.chat/).

### What are people saying about PonyDOS?

Nothing so far.

## FAQ

#### Does PonyDOS work on real hardware?

Yes! PonyDOS works on many different machines. The kernel can run on any
80286-compatible CPU, and the applications on any 8086-compatible CPU.

#### Is this _really_ not a DOS distribution?

PonyDOS is not a DOS distribution–it's also not a BSD, or a Hurd, or a
Minix, or a [Sortix](https://sortix.org/)!

#### How do I resize windows?

If the top-left corner of the window is the ↨ symbol, you can click and drag
the symbol to resize.

#### How do I adjust the mouse sensitivity?

Tweak `X_SENSITIVITY` and `Y_SENSITIVITY` in `ponydos.asm`. Lower values mean
higher sensitivity.

#### I started an application and it doesn't have a title bar, how do I exit it?

You don't.

#### How do I install PonyDOS?

At the moment, PonyDOS is only offered as a live floppy disk image with no
installation option, for your safety.

#### How do I stop my entire desktop from blinking?

Build with the [build option](#build-options) `-DBLINKY`.
