export type UniqueId = BigInt
export const uniqueid = (): UniqueId => {
    const random = crypto.getRandomValues(new Uint32Array(2))
    let buffer = 0n
    for (const num of random.values()) {
        buffer = (buffer << 32n) + BigInt(num)
    }
    return buffer !== 0n ? buffer : uniqueid()
}

export const documentToJsonReplacer = (k: string, v: any) => {
    return v instanceof Map
        ? Object.fromEntries(v.entries())
        : v instanceof Set
        ? [...v.values()]
        : typeof v === 'bigint'
        ? v.toString()
        : v
}
