<p align="center">
  <a href="https://sentry.io" target="_blank" align="center">
    <img src="https://sentry-brand.storage.googleapis.com/sentry-logo-black.png" width="280">
  </a>
  <br />
</p>

# Official Sentry SDK for Next.js

[![npm version](https://img.shields.io/npm/v/@sentry/nextjs.svg)](https://www.npmjs.com/package/@sentry/nextjs)
[![npm dm](https://img.shields.io/npm/dm/@sentry/nextjs.svg)](https://www.npmjs.com/package/@sentry/nextjs)
[![npm dt](https://img.shields.io/npm/dt/@sentry/nextjs.svg)](https://www.npmjs.com/package/@sentry/nextjs)
[![typedoc](https://img.shields.io/badge/docs-typedoc-blue.svg)](http://getsentry.github.io/sentry-javascript/)

## Links

- [Official SDK Docs](https://docs.sentry.io/platforms/javascript/guides/nextjs/)
- [TypeDoc](http://getsentry.github.io/sentry-javascript/)

## Compatibility

Currently, the Sentry Next.js SDK supports Next.js versions `10.0.8` - `11.1.3`. The SDK may work with some projects using Next.js 12, but it is not yet officially supported.

## General

This package is a wrapper around `@sentry/node` for the server and `@sentry/react` for the client, with added functionality related to Next.js.

To use this SDK, init it in the Sentry config files.

```javascript
// sentry.client.config.js

import * as Sentry from '@sentry/nextjs';

Sentry.init({
  dsn: "__DSN__",
  // ...
});
```

```javascript
// sentry.server.config.js

import * as Sentry from '@sentry/nextjs';

Sentry.init({
  dsn: "__DSN__",
  // ...
});
```

To set context information or send manual events, use the exported functions of `@sentry/nextjs`.

```javascript
import * as Sentry from '@sentry/nextjs';

// Set user information, as well as tags and further extras
Sentry.configureScope(scope => {
  scope.setExtra('battery', 0.7);
  scope.setTag('user_mode', 'admin');
  scope.setUser({ id: '4711' });
  // scope.clear();
});

// Add a breadcrumb for future events
Sentry.addBreadcrumb({
  message: 'My Breadcrumb',
  // ...
});

// Capture exceptions, messages or manual events
Sentry.captureMessage('Hello, world!');
Sentry.captureException(new Error('Good bye'));
Sentry.captureEvent({
  message: 'Manual',
  stacktrace: [
    // ...
  ],
});
```
