# Contributing to react-joyride

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

**Reporting Bugs**  
Before creating bug reports, please check this [list](https://github.com/gilbarbara/react-joyride/issues) as you might find out that you don't need to create one. When you are creating a bug report, please include as many details as possible.

**Implementation**  
Make sure you browse all the examples in the [demo](https://codesandbox.io/s/2zpjporp4p) and check the source code before opening an issue. We don't usually help with those directly but maybe some of the users might have some advice.

**Pull Requests**  
Before submitting a new pull request, open a new issue to discuss it. It may already been implemented but not published or we might have found the same situation before and decide against it.  

In any case:  
- Format files using these rules [EditorConfig](https://github.com/gilbarbara/react-joyride/blob/master/.editorconfig)
- Follow the [Javascript](https://github.com/gilbarbara/react-joyride/blob/master/.eslintrc) (ESLint) and [CSS](https://github.com/gilbarbara/react-joyride/blob/master/.scss-lint.yml) (scss-lint) styleguides.
- Document new code with jsdoc.

Thank you!
