import { useEffect, useRef } from 'react'
import Head from 'next/head'
import { useRouter } from 'next/router'
import { useSetRecoilState } from 'recoil'

import { User, UserPriority, UserSubscription } from '../data/user/user'
import { UserSettings } from '../data/user/settings'
import { useUserSetup } from '../hooks/useUserSetup'
import { getLocalStorage } from '../util/storage'
import Loading from '../components/loading'
import { TrialUsageRemaining } from '../globals/state'
import { getLocalTrialState, setLocalTrialState } from '../components/trialactions'
import { logError } from '../util/browser'
import { StyledApp } from './stories/[id]'

export default function Trial(): JSX.Element {
    const router = useRouter()
    const setupUser = useUserSetup()
    const setTrialUsageRemaining = useSetRecoilState(TrialUsageRemaining)

    const startingRef = useRef(false)
    useEffect(() => {
        if (startingRef.current) return
        const startTrial = async () => {
            try {
                const user = new User('', '', true)
                user.subscription = new UserSubscription()
                const localSettingsString = getLocalStorage('noAccountSettings')
                user.settings = new UserSettings()
                try {
                    user.settings = {
                        ...user.settings,
                        ...(localSettingsString ? JSON.parse(localSettingsString) : {}),
                    }
                } catch (error: any) {
                    logError(error)
                }
                user.settings.remoteDefault = false
                user.authenticated = true
                user.priority = new UserPriority()
                if (getLocalTrialState() < 0) {
                    setLocalTrialState(50)
                    setTrialUsageRemaining(50)
                }
                await setupUser(user)
            } finally {
                router.replace('/stories')
            }
        }
        startingRef.current = true
        startTrial().finally(() => {
            startingRef.current = false
        })
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [])
    return (
        <StyledApp id="app">
            <Head>
                <title>Start Trial - NovelAI</title>
            </Head>
            <Loading />
        </StyledApp>
    )
}
