import styled from 'styled-components'
import Head from 'next/head'
import Link from 'next/link'

const StyledTerms = styled.div`
    padding: 20px;
    display: flex;
    flex-direction: column;
`

export default function Terms(): JSX.Element {
    return (
        <StyledTerms>
            <Head>
                <title>Terms of Service - NovelAI</title>
            </Head>
            <section>
                <h1>Terms of Service</h1>
            </section>
            <section>
                <p>
                    The following terms (collectively referred to as Terms.) govern your use and access to our
                    service, website, and any first-party provided goods and services from Anlatan.
                    Collectively, these are referred to as Services.
                </p>
                <p>Effective: July 14th, 2021</p>
                <p>
                    Term: The term of the Agreement is until either party elects to terminate this agreement
                    pursuant to the terms provided in the Termination section of these Terms. Contact: You can
                    contact us at support@novelai.net. Our mailing address is 2055 Limestone Rd STE 200-C
                    Wilmington, DE 19808 United States.
                </p>
            </section>
            <section>
                <h2>1. Definitions</h2>
                <p>
                    1.1 First Party. All users of this service and first-party products, your relationship is
                    with Anlatan, a Delaware-based United States company, and the terms are governed by the
                    law of Delaware, U.S.A., unless preempted by U.S. federal law, without regard to conflict
                    of law rules.
                </p>
                <p>
                    1.2 GDPR. Refers to Regulation (EU) 2016/679 of the European Parliament and of the Council
                    of 27 April 2016.
                </p>
                <p>
                    1.3 Ownership. You, whether a legal or physical entity, retain all rights and ownership of
                    your Content. We do not claim any ownership rights to your Content. Unless you agree and
                    Anlatan agrees specifically to transfer your ownership to Anlatan.
                </p>
                <p>
                    1.4 Content. Content refers to the generated material that you specifically create using
                    our Services. Your content is wholly yours and is not representative or affiliated with
                    Anlatan, we do not act as publisher or platform to publish your Content.
                </p>
                <p>
                    1.5 Subscription-Based Services. Some of our Services require regular monthly payments to
                    access. These Services are subject to their applicable agreements and terms in the
                    following sections.
                </p>
                <p>
                    1.6 Authorized Payment Processor. We use a payment processor agent in order to process our
                    Services’ billing intervals.
                </p>
                <p>
                    1.7 Updates to Terms. Any material changes to the Terms will be notified to you with the
                    date being announced in advance. If you do not agree to the amended terms, you must stop
                    using our Services.
                </p>
                <p>
                    1.8 Licensing. Our Services are licensed, not sold, to you. You retain unlimited access to
                    the Services throughout the duration of the subscription unless the Terms are breached. We
                    reserve the right to cancel any of the Services if Terms are breached.
                </p>
                <p>
                    1.9 Definition of Business Day and Hours. Anlatan operates from 9am to 5pm Monday to
                    Friday and observes all US Federal Holidays.
                </p>
                <p>
                    1.10 Charges. All Subscription-Based Services provided to you are based on 30-day
                    intervals.
                </p>
                <p>
                    1.11 Effective Date. The effective date is when Terms are operational and effective, until
                    the Terms are amended by Anlatan.
                </p>
                <p>
                    1.12 Force Majeure. In no event shall Anlatan be responsible or liable for any failure or
                    delay in the performance of its obligations hereunder arising out of or caused by,
                    directly or indirectly, forces beyond its control, including, without limitation, strikes,
                    work stoppages, accidents, acts of war or terrorism, civil or military disturbances,
                    nuclear or natural catastrophes or acts of God, and interruptions, loss or malfunctions of
                    utilities, communications or computer (software and hardware) services.
                </p>
                <p>
                    1.13 Hosted Services. Our Services will be made available to you via the internet
                    according to the Terms.
                </p>
            </section>
            <section>
                <h2>2. Hosted Services</h2>
                <p>
                    2.1 Anlatan shall provide to you on your agreement with the terms and conditions the
                    Services that are publicly available. Upon payment of a Services’ Subscription, we will
                    provide you with necessary access to consume our Services that are subscription based.
                </p>
                <p>
                    2.2 We grant you a non-exclusive license to access our Subscription-Based Services. This
                    license cannot be transferred, assigned, or be used in any prohibited, restricted use.
                    This license cannot be used for misconduct in the Terms.
                </p>
                <p>
                    2.3 In accordance to the Terms, none of the following shall constitute as a breach of the
                    Terms.
                </p>
                <p>2.3.1 A Force Majeure Event;</p>
                <p>2.3.2 Technical faults or network communication errors;</p>
                <p>2.3.3 Faults of your computer systems or networks;</p>
                <p>2.3.4 Inability for you to use a normal computing system;</p>
                <p>2.3.5 Routine maintenance.</p>
            </section>
            <section>
                <h2>3. Data Protection</h2>
                <p>
                    3.1 Anlatan will be compliant with all Data Protection Laws with respect to processing of
                    user personal data.
                </p>
            </section>
            <section>
                <h2>4. Payments and Charges</h2>
                <p>
                    4.1 Charges. By using the Subscription-Based Services, you agree to pay Anlatan for the
                    Services’ provided within this agreement.
                </p>
                <p>
                    4.1.1 Charges are based on stated values, exclusive of any value added taxes or sales
                    taxes. Applicable sales taxes and value added taxes will be assessed by our Authorized
                    Payment Processor. All charges are referenced in US dollars.
                </p>
                <p>
                    4.1.2 Anlatan’s Subscription-Based Services does not offer refunds unless explicitly
                    granted by the Company. If you have a Subscription-Based Service then your access to the
                    Services will be active until the expiration of the subscription. If you decide to cancel
                    your subscription then you will not be charged for your next month’s subscription and your
                    access to the Subscription-Based Services will be revoked at the end of the active period.
                </p>
                <p>
                    4.2 Payments. Anlatan is authorized to issue billing notices for the Services’
                    Subscriptions from time to time during the Term.
                </p>
                <p>
                    4.2.1 You are responsible for all fees and charges, including taxes related to your
                    account before the end of your Services’ Subscription Date. If you are enrolled through an
                    Authorized Payment Processor’s automated billing service, then it is your responsibility
                    to contact the agent to cancel your subscription either through directly contacting them
                    or through our payment center.
                </p>
                <p>
                    4.2.2 You must pay for your Services’ Subscription through an Authorized Payment
                    Processor. You must agree to any terms and conditions that they provide in order to for us
                    to receive payment. All payments must be received in US dollars.
                </p>
                <p>
                    4.2.3 If you do not pay on the date of the Services’ Subscription renewal then we have the
                    sole right to terminate your access to the Services without any recompense to any
                    potential damages.
                </p>
            </section>
            <section>
                <h2>5. Use of Services</h2>
                <p>
                    5.1 Subscription-Based Software License. If you are subject to the compliance with the
                    Terms during the duration of your subscription, we grant you an account exclusive license
                    to consume and access the Services: (1) as long as your subscription is valid and (2) in
                    accordance with the Terms accompanying the Services. Your subscription lets you access the
                    Services up to one account, on any number of devices.
                </p>
                <p>
                    5.2 Authorized Users. You must be 18 years or older and be capable of entering a legal
                    contract in the United States of America in order to use the Services.
                </p>
                <p>5.3 Restrictions. Unless permitted in the Terms, you must not:</p>
                <p>5.3.1 Host an account on a publicly available domain;</p>
                <p>5.3.2 Allow third parties to access the account remotely;</p>
                <p>5.3.3 Circumvent technological measures intended to control access to the Account;</p>
                <p>
                    5.3.4 Develop, distribute, or use with the Services, products that circumvent the
                    technological measures to protect the Services.
                </p>
                <p>
                    5.3.5 Rent, lease, sell, sublicense, assign, or transfer any portion of the account or
                    your rights of the Services in the account.
                </p>
                <p>
                    5.4 Updates. The Services may automatically download and install updates from Anlatan on a
                    routine or occasional basis. These updates may take the form of bug fixes, new features,
                    new models, and user experience improvements. You agree to receive such updates from
                    Anlatan as part of your use with the Services.
                </p>
                <p>
                    5.5 Supported Web Browsers. We offer support for the Services through Google Chrome,
                    Firefox, Safari, and Edge. Any other browser that is not expressly stated in the terms and
                    conditions remains unsupported.
                </p>
                <p>
                    5.6 Login credentials. Access to Anlatan’s Services requires the use of login credentials.
                    This information is not stored with us and we bear no responsibility in storing or
                    retrieving these credentials if lost. You have full responsibility secure and keep your
                    credentials to access our Services. You agree to indemnify Anlatan from any and all
                    liabilities, losses actions, damages or claims (including all reasonable expenses, costs,
                    and attorneys’ fees) arising out the inability to access your content from encryption.
                </p>
                <p>
                    5.7 Warranties. Anlatan shall not be responsible or liable for any inaccuracies in the
                    data base or the information processed by or through the Services nor shall it have any
                    liability for any act or failure to act except as expressly set forth herein, except gross
                    negligence or willful misconduct. All warranties express or implied, including without
                    limitation, any warranty of fitness for a particular purpose, merchantability, good and
                    workmanlike product or service or otherwise, are disclaimed and waived.
                </p>
                <p>
                    5.8 Limitation of Liability. In no event will either you or Anlatan will have any
                    liability whatsoever to the other Party for any indirect, special, consequential,
                    incidental or punitive damages, including loss of anticipated profits or revenue in
                    connection with or arising from anything said, omitted or done hereunder (collectively,
                    “Consequential Damages”), even if the other Party has been advised of the possibility of
                    such damages. You agree to indemnify Anlatan of all liability from the Services.
                </p>
                <p>
                    5.9 Feedback and Suggestions. Anlatan may provide channels to provide feedback and
                    suggestions about our Services. You agree that any feedback given to Anlatan is without
                    any compensation or credit that is provided to us.
                </p>
                <p>
                    5.10 Promotions and Contests. From time to time, Anlatan may provide promotional offers
                    and contests. These Terms apply to these events and if you choose to participate in these
                    events you will have to agree to any additional terms and conditions provided.
                </p>
                <p>
                    5.11 Storage. We allow you to back up your Content and locally store your content. We
                    recommend regularly backing up your Content. Content stored on our servers is encrypted
                    and you bear the decryption key in the form of your password and email address. If your
                    Password is lost then we cannot recover your Content that is stored on our server. At the
                    end of your Services’ subscription, we make reasonable effort to allow the export your
                    Content from our Services. This transition must be completed within 45 days, after which
                    we reserve the right to delete your Content.
                </p>
            </section>
            <section>
                <h2>6. Privacy Policy</h2>
                <p>
                    6.1 Access to your Content. Under law, we will only access your Content to provide the
                    Services to your account. Your Content may not be plainly viewed by any agent or principle
                    of Anlatan without expressed permission from yourself. In order to perform the Services,
                    we may need to access, transform, and transmit your content between Anlatan and yourself.
                </p>
                <p>
                    6.2 Sharing with other Data Collectors. Unless required by applicable law, to process
                    payments, or to provide the Services; we do not share information with any third parties.
                    Any information that is disclosed to third party will be notified to you. Your Content
                    will be accessed by our Services’ providers in order to fulfill the Services.
                </p>
                <p>
                    6.3 Security of Information. Protection of user data is one of our top priorities. We have
                    enacted strict data access controls, encryption methods, and physical controls in order to
                    protect your information.
                </p>
                <p>
                    6.4 Storage of Information. Your personal information and Content are stored on Anlatan’s
                    servers and the servers of companies that provide services to us, including data storage.
                    Your content is encrypted while it is stored on our servers or storage service providers.
                </p>
                <p>
                    6.5 Logging of Requests. We do not log the content of your requests without your explicit
                    consent.
                </p>
                <p>
                    6.6 If you are under an applicable jurisdiction, you may request a copy of your personal
                    information; to correct, delete, or restrict processing of your personal information. You
                    may, under these applicable jurisdictions obtain the relevant personal information
                    provided to us for a contract or with your consent in a structured machine-readable
                    format. These rights may be limited. Limitations which may include but is not limited to
                    revealing information that would reveal another person personal information, infeasibility
                    of retrieval, information we are required to keep by law, or information that is required
                    to defend claims against us.
                </p>
                <p>
                    6.7 Retention length. We keep your data has long as you have an active account from one of
                    our Services. If you close your account, we will begin to delete data that does not have
                    justifiable business reason. If you are under a GDPR-jurisdiction and request to be
                    forgotten, or wish to voluntary have your account data removed we will process your
                    request as soon as possible. You may not elect to rescind this decision.
                </p>
                <p>
                    6.8 GDPR AI Data and Content. You agree that any information that is voluntary provided to
                    us for AI model training cannot be deleted after AI model training has started.
                    Furthermore, you agree that you cannot exercise the right to be forgotten on data that is
                    produced by the AI.
                </p>
                <p>
                    6.9 Updates. Over the course of business, we will make updates to this Privacy Policy to
                    reflect new changes in law, Anlatan’s business practices, new technologies, or for other
                    purposes. If we do, you will be notified 30 days in advance in regards to any material
                    changes to the policy. We will change the “last updated” date of this policy to reflect
                    the latest updated policy.
                </p>
            </section>
            <section>
                <h2>7. License Term</h2>
                <p>
                    7.1 Under acceptable compliance with the Terms and applicable law, you may access and use
                    the Services that we provide, and that you license from Anlatan. Your license expires at
                    the end of the term set forth in your Services’ subscription order. The Services provided
                    may be modified on your renewal date and may not match the Services you first purchased
                    from Anlatan. You agree that your decision to use or purchase Software or Services is not
                    contingent on the delivery of any future functionality or features.
                </p>
                <p>
                    7.2 Intellectual Property. Anlatan remains the sole owner of all right, title, and
                    interest in the Services. Except as stated in Terms, we do not grant you any rights to
                    patents, copyrights, other users’ Content, trade secrets, trademarks, or any other rights
                    in respects to the items in the Services or Software. We reserve all rights not granted
                    under the Terms.
                </p>
                <p>
                    7.3 Your license will be prematurely terminated if consideration received from you is
                    fraudulent or otherwise illegally obtained.
                </p>
            </section>
            <section>
                <h2>8. Account</h2>
                <p>
                    8.1 You are responsible for all activity that occurs via your account even if that
                    activity is not by you or is without your knowledge or consent. You may not (1) share your
                    account information (except with an authorized account administrator), whether
                    intentionally or unintentionally; or (2) use another person’s account.
                </p>
                <p>
                    8.2 You are responsible for keeping your account active, which means you must sign in
                    periodically to avoid any disruption or loss of access to the Services, or termination of
                    your account. If you don{"'"}t sign into your account periodically, we reserve the right
                    to assume your account is inactive, and you agree that we may close it for you.
                </p>
            </section>
            <section>
                <h2>9. Misconduct</h2>
                <p>
                    9.1 Misuse of Services. Anlatan defines misconduct of the Services including but not
                    limited to:
                </p>
                <p>
                    9.1.1 Use the Services or Software without, or in violation of, a written license or
                    agreement with Anlatan;
                </p>
                <p>9.1.2 Copy, modify, host, sublicense, or resell the Services;</p>
                <p>
                    9.1.3 Enable or allow others to use the Services or Software using your account
                    information;
                </p>
                <p>
                    9.1.4 Unless expressively allowed and agreed, you may not access or attempt to access the
                    Services in any unauthorized or unsupported manner;
                </p>
                <p>
                    9.1.5 Circumvent any access or use restrictions put into place to prevent certain uses of
                    the Services;
                </p>
                <p>
                    9.1.6 Unless expressively allowed and agreed, you may not use of botnets or automated
                    systems in the Services that disrespect the limitations provided by our Service or
                    otherwise place excessive strain on our Services;
                </p>
                <p>
                    9.1.7 Use the Services as to provide as a substitute for any licensed profession. Licensed
                    professions included but are not limited to legal, financial, investment, taxation,
                    accountancy, medical, and other professions;
                </p>
                <p>9.1.8 Use to circumvent regulated business such as gambling;</p>
                <p>
                    9.2 Account Termination. We reserve the right to terminate an account if found to be in
                    breach of the Terms or is engaged in misconduct accordance with our Terms.
                </p>
            </section>
            <section>
                <h2>10. Termination</h2>
                <p>
                    10.1 Termination by You. If you wish to terminate this agreement you may do so by
                    discontinuing your use of the Services provided by Anlatan.
                </p>
                <p>
                    10.2 Termination by Anlatan. We may terminate your access to the Services with or without
                    any cause, with or without notice, effectively immediately.
                </p>
                <p>
                    10.3 Survivorship of Provisions. Provisions in the Terms, without limitation such as
                    ownership, warranty disclaimers, indemnity, and limitations of liability.
                </p>
            </section>
            <div style={{ marginTop: '20px' }} />
            <Link href="/">Back</Link>
        </StyledTerms>
    )
}
