import {
    NOVELAI_BACKEND_URL,
    NEXT_PUBLIC_ENVIRONMENT,
    NOVELAI_MOCK_ENV,
    NOVELAI_RECAPTCHA_KEY,
    NOVELAI_PADDLE_SANDBOX,
    NOVELAI_PADDLE_VENDOR_ID,
    NOVELAI_PADDLE_OPUS_ID,
    NOVELAI_PADDLE_SCROLL_ID,
    NOVELAI_PADDLE_TABLET_ID,
    NEXT_PUBLIC_SENTRY_DSN,
    NEXT_PUBLIC_COMMITHASH,
    NOVELAI_PADDLE_GIFTKEY_OPUS_ID,
    NOVELAI_PADDLE_GIFTKEY_SCROLL_ID,
    NOVELAI_PADDLE_GIFTKEY_TABLET_ID,
} from 'react-native-dotenv'
export const Environment = NEXT_PUBLIC_ENVIRONMENT || 'debug'
export const CommitHash = NEXT_PUBLIC_COMMITHASH || 'unknown'

export const SentryDSN = NEXT_PUBLIC_SENTRY_DSN || ''

export const BackendURL = NOVELAI_BACKEND_URL || 'http://example.com'
export const MockEnv = NOVELAI_MOCK_ENV === 'true'
export const RecaptchaKey = NOVELAI_RECAPTCHA_KEY || ''
export const PaddleSandbox = NOVELAI_PADDLE_SANDBOX === 'true'
export const PaddleVendorID = Number.parseInt(NOVELAI_PADDLE_VENDOR_ID || '123')
export const PaddleOpusID = Number.parseInt(NOVELAI_PADDLE_OPUS_ID || '123')
export const PaddleScrollID = Number.parseInt(NOVELAI_PADDLE_SCROLL_ID || '123')
export const PaddleTabletID = Number.parseInt(NOVELAI_PADDLE_TABLET_ID || '123')

export const PaddleGitfKeyTabletID = Number.parseInt(NOVELAI_PADDLE_GIFTKEY_TABLET_ID || '26963')
export const PaddleGitfKeyScrollID = Number.parseInt(NOVELAI_PADDLE_GIFTKEY_SCROLL_ID || '27468')
export const PaddleGitfKeyOpusID = Number.parseInt(NOVELAI_PADDLE_GIFTKEY_OPUS_ID || '27469')

export const BackendURLRegister = BackendURL + '/user/register'
export const BackendURLLogin = BackendURL + '/user/login'
export const BackendURLUserData = BackendURL + '/user/data'
export const BackendURLSubscriptions = BackendURL + '/user/subscription'
export const BackendURLSubscriptionBind = BackendURL + '/user/subscription/bind'
export const BackendURLSubscriptionsChange = BackendURL + '/user/subscription/change'
export const BackendURLUserGiftKeys = BackendURL + '/user/giftkeys'
export const BackendURLPriority = BackendURL + '/user/priority'
export const BackendURLKeystore = BackendURL + '/user/keystore'
export const BackendURLObjects = BackendURL + '/user/objects'
export const BackendURLStories = BackendURL + '/user/objects/stories'
export const BackendURLStoryContent = BackendURL + '/user/objects/storycontent'
export const BackendURLPresets = BackendURL + '/user/objects/presets'
export const BackendURLAIModules = BackendURL + '/user/objects/aimodules'
export const BackendURLClientSettings = BackendURL + '/user/clientsettings'
export const BackendURLGenerate = BackendURL + '/ai/generate'
export const BackendURLGenerateStream = BackendURL + '/ai/generate-stream'
export const BackendURLRecoveryInitiation = BackendURL + '/user/recovery/request'
export const BackendURLRecoverySubmit = BackendURL + '/user/recovery/recover'
export const BackendURLPrefixSubmit = BackendURL + '/ai/module/train'
export const BackendURLPrefix = BackendURL + '/ai/module'
export const BackendURLPrefixAll = BackendURL + '/ai/module/all'
export const BackendURLPrefixDelete = BackendURL + '/ai/module/delete'
export const BackendURLPurchaseSteps = BackendURL + '/ai/module/buy-training-steps'
export const BackendURLChangeAuth = BackendURL + '/user/change-access-key'
export const BackendURLStoryShelves = BackendURL + '/user/objects/shelf'
export const BackendURLVerifyEmail = BackendURL + '/user/verify-email'
export const BackendURLInformation = BackendURL + '/user/information'
export const BackendURLRequestVerifyEmail = BackendURL + '/user/request-email-verification'
export const BackendURLResendVerifyEmail = BackendURL + '/user/resend-email-verification'
export const BackendURLRequestDeleteAccount = BackendURL + '/user/deletion/request'
export const BackendURLVerifyDeleteAccount = BackendURL + '/user/deletion/delete'
export const BackendURLSubmitContest = BackendURL + '/user/submission'
export const BackendURLVoteContest = BackendURL + '/user/vote-submission'
export const BackendTTSUrl = BackendURL + '/ai/generate-voice'
export const BreakpointMobile = 1250
export const MaxLoreSearchDistance = 10000
export const MaxTokens = 2048

export const mobileSize = '1250px'
export const smallMobileSize = '900px'
export const smallerMobileSize = '600px'
