﻿interface Algorithm {
    name: string
}

type BufferSource = ArrayBufferView | ArrayBuffer

interface AesCbcParams extends Algorithm {
    iv: BufferSource
}

interface KeyAlgorithm {
    name: string
}

type KeyUsage =
    | 'decrypt'
    | 'deriveBits'
    | 'deriveKey'
    | 'encrypt'
    | 'sign'
    | 'unwrapKey'
    | 'verify'
    | 'wrapKey'
type KeyType = 'private' | 'public' | 'secret'

/**
 * The CryptoKey dictionary of the Web Crypto API represents a cryptographic key.
 * Available only in secure contexts.
 */
interface CryptoKey {
    readonly algorithm: KeyAlgorithm
    readonly extractable: boolean
    readonly type: KeyType
    readonly usages: KeyUsage[]
}

declare var CryptoKey: {
    prototype: CryptoKey
    new (): CryptoKey
}
