﻿import styled, { css } from 'styled-components/native'

//Headings
export const HeadingLargeM = css`
    font-family: ${(props) => props.theme.fonts.headings};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 20px;
    line-height: 36px;
`

export const HeadingMediumM = css`
    font-family: ${(props) => props.theme.fonts.headings};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 18px;
    line-height: 32px;
`

export const HeadingSmallM = css`
    font-family: ${(props) => props.theme.fonts.headings};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 16px;
    line-height: 28px;
`

export const HeadingLarge600M = css`
    ${HeadingLargeM}
    font-weight: 600;
`

export const HeadingLarge600 = styled.Text`
    ${HeadingLarge600M}
`

export const HeadingLarge400 = styled.Text`
    ${HeadingLargeM}
    font-weight: 400;
`

export const HeadingMedium600M = css`
    ${HeadingMediumM}
    font-weight: 600;
`

export const HeadingMedium600 = styled.Text`
    ${HeadingMedium600M}
`

export const HeadingMedium500M = css`
    ${HeadingMediumM}
    font-weight: 500;
`

export const HeadingSmall700M = css`
    ${HeadingSmallM}
    font-weight: 700;
`

export const HeadingSmall600M = css`
    ${HeadingSmallM}
    font-weight: 600;
`

export const HeadingSmall600 = styled.Text`
    ${HeadingSmall600M}
`

//Body
export const BodyLargeM = css`
    font-family: ${(props) => props.theme.fonts.default};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 16px;
    line-height: 21px;
`

export const BodyMediumM = css`
    font-family: ${(props) => props.theme.fonts.default};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 14px;
    line-height: 18px;
`

export const BodyLarge700M = css`
    ${BodyLargeM}
    font-weight: 700;
`

export const BodyLarge700 = styled.Text`
    ${BodyLarge700M}
`

export const BodyLarge600M = css`
    ${BodyLargeM}
    font-weight: 600;
`

export const BodyLarge600 = styled.Text`
    ${BodyLarge600M}
`

export const BodyLarge400M = css`
    ${BodyLargeM}
    font-weight: 400;
`

export const BodyLarge400 = styled.Text`
    ${BodyLarge400M}
`

export const BodyMedium700M = css`
    ${BodyMediumM}
    font-weight: 700;
`

export const BodyMedium700 = styled.Text`
    ${BodyMedium700M};
`

export const BodyMedium600M = css`
    ${BodyMediumM}
    font-weight: 600;
`

export const BodyMedium600 = styled.Text`
    ${BodyMedium600M}
`

export const BodyMedium400M = css`
    ${BodyMediumM}
    font-weight: 400;
`

export const BodyMedium400 = styled.Text`
    ${BodyMedium400M}
`

export const BodySmall400Faded = styled.Text`
    font-family: ${(props) => props.theme.fonts.default};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 12px;
    opacity: 0.5;
`

//other
export const SoftFade = css`
    opacity: 0.7;
`

export const HardFade = css`
    opacity: 0.5;
`

export const Bold = styled.Text`
    font-weight: 700;
`

export const Heading = styled.Text`
    color: ${(props) => props.theme.colors.textHeadings};
`

export const BodyMedium600Faded = styled.Text`
    ${BodyMedium600M}
    ${SoftFade}
`

export const BodyMedium400Faded = styled.Text`
    ${BodyMedium400M}
    ${SoftFade}
`

export const BodyXL600M = css`
    font-family: ${(props) => props.theme.fonts.default};
    color: ${(props) => props.theme.colors.textMain};
    font-weight: 600;
    font-size: 18px;
    line-height: 22px;
`

export const BodyXL600 = styled.Text`
    ${BodyXL600M}
`

export const WarningText = styled.Text`
    ${BodyMedium400M};
    color: ${(props) => props.theme.colors.warning};
`
