import React, { useState } from 'react'
import { View } from 'react-native'
import TypeWriter from 'react-native-typewriter'
import { useRecoilValue } from 'recoil'
import { NativeStackNavigationProp } from '@react-navigation/native-stack'
import { Session, SessionValue, SiteTheme } from '../../../shared/globals/state'
import { emailConfirmationRequiredDate } from '../../../shared/util/util'
import {
    Background,
    TitleText,
    SubtitleText,
    PromoText,
    LandingView,
    TypeWriterText,
    HeaderText,
    LoginButton,
    LoginButtonText,
    SignUpButtonText,
} from './landing.style'

import { PenTipIcon } from '../common/icons'
import { RootStackParamList } from '../app'
import { RegularButton } from '../common/button.style'

const typewriterStrings = [
    'a castle across the bay',
    'a city powered by steam',
    'a city reclaimed by nature',
    'childhood memories',
    'a fractured past',
    'a journey through the mountains',
    'a kingdom in the desert',
    'a land of magic',
    'a misty wood',
    'a moonlit curse',
    'a nation at war',
    'the age of man',
    'a new case',
    'a quiet life in the country',
    'a riverside stroll',
    'a somber evening',
    'a twisted reality',
    'a vibrant coastline',
    'a walk through the gardens',
    'a warm inn',
    'a world tearing at the seams',
    'an armed insurrection',
    'an enchanted library',
    'an ephemeral dreamscape',
    'an expedition into the unknown',
    'ancient prophecies',
    'bustling markets',
    'a calm night at sea',
    'exploring crystaline caverns',
    'losing your way',
    'egg?',
    'a picnic by the lake',
    'far-off mountains',
    'foreboding hallways',
    'heroes and villains',
    'hidden temples',
    'inspiring tales',
    'forgotten places',
    'eating glitter',
    'otherworldly beings',
    'rough waters',
    'rumblings of war',
    'the Katangese spirit',
    'rural society',
    'hunting sky whales',
    'strange occurrences',
    'the beginning of a new day',
    'the city of Alchemy',
    'the dead of night',
    'the end of an era',
    'the gardens of Heaven',
    'the gardens of Hell',
    'the Home of the Gods',
    'the Imperial Court',
    'the palace menagerie',
    'the path to the underworld',
    "the Queen's coronation",
    'the struggles of an artist',
    "the sun's blessings",
    'the surface of the Moon',
    'things beyond comprehension',
    'travelling through frozen lands',
    'unexpected romance',
    'unseen depths',
    'Victorian times',
    'eating the Maclanky',
]

export default function Landing(props: {
    navigation: NativeStackNavigationProp<RootStackParamList, 'landing'>
}): JSX.Element {
    const [stringIndex, setStringIndex] = useState(0)
    const [typingDir, setTypingDir] = useState(1)
    const theme = useRecoilValue(SiteTheme)
    const authenticated = useRecoilValue(SessionValue('authenticated'))
    const session = useRecoilValue(Session)

    const onTypingEnd = () => {
        setTimeout(
            () => {
                if (typingDir === -1) {
                    setStringIndex((stringIndex + 1) % typewriterStrings.length)
                }

                setTypingDir(typingDir === 1 ? -1 : 1)
            },
            typingDir === 1 ? 1500 : 500
        )
    }

    const onLoginPushed = () => {
        if (
            authenticated &&
            (session.information.emailVerified ||
                session.information.trialActivated ||
                session.information.accountCreatedAt <= emailConfirmationRequiredDate)
        )
            props.navigation.navigate('storyapp')
        else props.navigation.navigate('login')
    }

    return (
        <Background>
            <LandingView>
                <View style={{ flexDirection: 'row' }}>
                    <PenTipIcon fill={theme.colors.textMain} />
                    <TitleText>NovelAI</TitleText>
                    <SubtitleText>beta</SubtitleText>
                </View>
                <HeaderText>Write about</HeaderText>
                <TypeWriterText>
                    <TypeWriter
                        typing={typingDir}
                        style={{ color: theme.colors.textMain }}
                        onTypingEnd={onTypingEnd}
                    >
                        {typewriterStrings[Math.floor(stringIndex)]}
                    </TypeWriter>
                    |
                </TypeWriterText>
                <PromoText>
                    Driven by AI, painlessly construct unique stories, thrilling tales, intriguing romances,
                    or just fool around. Anything goes!
                </PromoText>
                <LoginButton onPress={onLoginPushed}>
                    <LoginButtonText>Log In</LoginButtonText>
                </LoginButton>
                <RegularButton onPress={() => props.navigation.navigate('signup')}>
                    <SignUpButtonText>Sign Up</SignUpButtonText>
                </RegularButton>
            </LandingView>
        </Background>
    )
}
