import styled, { css } from 'styled-components/native'

export const StageButton = styled.Pressable<{ disabled: boolean }>`
    flex-direction: row;
    justify-content: center;
    align-items: center;
    flex-shrink: 1;
    padding-vertical: 5px;
    opacity: ${(props) => (props.disabled ? 0.3 : 1)};
`

export const ContextDisplay = styled.View`
    background-color: ${(props) => props.theme.colors.bg1};
    border: 1px ${(props) => props.theme.colors.bg3};
    padding: 10px;
    margin-vertical: 10px;
`

const ContextStyle = css`
    font-family: ${(props) => props.theme.fonts.code};
    color: ${(props) => props.theme.colors.textMain};
    font-size: 14px;
    font-weight: 400;
`

export const ShownContext = styled.Text`
    ${ContextStyle}
`

export const StyledContext = styled.Text<{ color: string; selected: boolean }>`
    ${ContextStyle}
    ${(props) =>
        props.color !== '' &&
        css`
            color: ${props.color};
        `}
    ${(props) =>
        props.selected &&
        css`
            background-color: ${props.theme.colors.textHighlight};
        `}
`

export const InvisibleContext = styled.Text`
    ${ContextStyle}
    opacity: 0;
`
