import React, { lazy, Suspense, useEffect, useState } from 'react'
import { View } from 'react-native'
import { useRecoilValue } from 'recoil'
import { SelectedStoryMode } from '../../../shared/globals/state'
import { useSelectedStory } from '../../../shared/hooks/useSelectedStory'
import { toast } from '../../util/toast'
import Spinner from '../common/spinner'

const EditorContainer = lazy(() => import('./container'))

export default function EditorPanel(): JSX.Element {
    const { id, story, meta, loaded, modified, error } = useSelectedStory()
    useRecoilValue(SelectedStoryMode)

    const isLoading = !!id && (!meta || (!story?.story && !story?.document) || !loaded)
    const isDirty = !!id && modified

    const [showScenarios, setShowScenarios] = useState(false)
    const [showEditor, setShowEditor] = useState(false)
    const [showTop, setShowTop] = useState(false)

    useEffect(() => {
        setShowEditor(!isLoading && isDirty)
        setShowTop(!isLoading && !isDirty && showScenarios)
    }, [isDirty, isLoading, showScenarios])

    useEffect(() => {
        if (error) toast(error)
    }, [error])

    return (
        <View>
            {showEditor && !isLoading && (
                <Suspense
                    fallback={
                        <View>
                            <Spinner visible={true} />
                        </View>
                    }
                >
                    <EditorContainer story={story!} meta={meta!} />
                </Suspense>
            )}
        </View>
    )
}
