import { Module } from "@nestjs/common";
import { APP_GUARD } from "@nestjs/core";
import { JwtModule } from "@nestjs/jwt";
import { ThrottlerGuard } from "@nestjs/throttler";
import { TypeOrmModule } from "@nestjs/typeorm";
import { MailgunModule } from "@nextnm/nestjs-mailgun";
import { AuthService } from "./auth.service";
import { SubscriptionController } from "./subscription/subscription.controller";
import { SubscriptionData } from "./subscription/subscription.entity";
import { SubscriptionService } from "./subscription/subscription.service";
import { TaskPriorityService } from "./task-priority.service";
import { UserData } from "./user-data.entity";
import { UserSubmission } from "./user-submission.entity";
import { UserController } from "./user.controller";
import { User } from "./user.entity";
import { UserService } from "./user.service";
import { UserSubmissionVote } from "./user-submission-vote.entity";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      User,
      UserData,
      SubscriptionData,
      UserSubmission,
      UserSubmissionVote,
    ]),
    JwtModule.registerAsync({
      useFactory: () => {
        return {
          secret: process.env.JWT_SIGN_SECRET,
          signOptions: { expiresIn: "30d" },
        };
      },
    }),
    MailgunModule.forAsyncRoot({
      useFactory: async () => {
        return {
          username: "api",
          key: process.env.MAILGUN_KEY,
        };
      },
    }),
  ],
  controllers: [UserController, SubscriptionController],
  providers: [
    {
      provide: APP_GUARD,
      useClass: ThrottlerGuard,
    },
    UserService,
    AuthService,
    TaskPriorityService,
    SubscriptionService,
  ],
  exports: [UserService, AuthService, TaskPriorityService],
})
export class UserModule {}
