import { nanoid } from "nanoid";
import {
  BeforeInsert,
  BeforeUpdate,
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryColumn,
} from "typeorm";
import { User } from "./user.entity";

@Entity("user_submission_vote")
export class UserSubmissionVote {
  @PrimaryColumn()
  id: string;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  lastUpdatedAt: Date;

  @BeforeInsert()
  generateID() {
    this.id = nanoid();
  }

  @BeforeUpdate()
  updateTimestamp() {
    this.lastUpdatedAt = new Date();
  }

  @Column({ length: 64 })
  submissionId: string;

  @Column({ default: "", length: 256 })
  event: string;

  @ManyToOne(() => User, { onDelete: "CASCADE" })
  @JoinColumn()
  owner: User;
}
