import { ApiProperty } from "@nestjs/swagger";
import { IsEnum, IsNotIn, IsString } from "class-validator";
import { SubscriptionTiers } from "../../../shared/subscription-tiers";

export class ChangeSubscriptionPlanRequest {
  @IsEnum(SubscriptionTiers)
  @IsString()
  @IsNotIn(["NONE"])
  @ApiProperty({
    description: "New plan SKU",
  })
  newSubscriptionPlan: SubscriptionTiers;
}
