import { ApiProperty } from "@nestjs/swagger";
import { MaxLength, MinLength } from "class-validator";

export class UserData {
  @ApiProperty({
    description: "Object ID",
  })
  id: string;

  @MinLength(1)
  @MaxLength(16)
  type: string;

  @MaxLength(128)
  @ApiProperty({
    description: "Accompanying non confidential information",
  })
  meta: string;

  @ApiProperty({
    description: "Base64-encoded buffer",
  })
  data: string;

  @ApiProperty({
    description: "UNIX timestamp",
  })
  lastUpdatedAt: number;

  @ApiProperty({
    description: "Incremental revision of the object",
  })
  changeIndex: number;
}
