import { ApiProperty } from "@nestjs/swagger";
import { IsBase64, IsNumber, IsOptional } from "class-validator";

export class UpdateKeystoreRequest {
  @IsBase64()
  @ApiProperty({
    description: "Base64-encoded keystore (or empty string to clear)",
  })
  keystore: string;

  @IsOptional()
  @IsNumber()
  @ApiProperty({
    description: "Current change index",
  })
  changeIndex?: number;
}
