import { ApiProperty } from "@nestjs/swagger";

export class SubscriptionTierPerks {
  @ApiProperty({
    description: "Amount of max priority actions",
  })
  maxPriorityActions: number;

  @ApiProperty({
    description: "Start priority amount",
  })
  startPriority: number;

  @ApiProperty({
    description: "Amount of granted context tokens",
  })
  contextTokens: number;

  @ApiProperty({
    description: "Is max priority unlimited",
  })
  unlimitedMaxPriority: boolean;

  @ApiProperty({
    description: "Amount of module training steps granted every month",
  })
  moduleTrainingSteps: number;
}

class SubscriptionAvailableTrainingSteps {
  @ApiProperty({
    description:
      "Amount of available fixed module training steps left (reset every month)",
  })
  fixedTrainingStepsLeft: number;

  @ApiProperty({
    description: "Amount of available purchased module training steps left",
  })
  purchasedTrainingSteps: number;
}

export class SubscriptionResponse {
  @ApiProperty({
    description:
      "Subscription internal tier number, see SubscriptionTiers enum",
  })
  tier: number;

  @ApiProperty({
    description: "Is subscription active as of the moment of the request",
  })
  active: boolean;

  @ApiProperty({
    description: "UNIX timestamp of subscription expiration",
  })
  expiresAt: number;

  @ApiProperty({
    description: "Subscription perks",
  })
  perks: SubscriptionTierPerks;

  @ApiProperty({
    description: "Payment processor arbitrary data",
  })
  paymentProcessorData: any;

  @ApiProperty({
    description: "Amount of available module training steps left",
  })
  trainingStepsLeft: SubscriptionAvailableTrainingSteps;
}
