import { IsEmail, IsString, MaxLength, MinLength } from "class-validator";

export class EmailVerificationStartRequest {
  @IsString()
  @IsEmail()
  email: string;
}

export class EmailVerificationRequest {
  @IsString()
  @MinLength(64)
  @MaxLength(64)
  verificationToken: string;
}
