import { ApiProperty } from "@nestjs/swagger";
import { IsEmail, IsNotEmpty, IsString, MinLength } from "class-validator";

export class DeletionStartRequest {
  @IsString()
  @IsNotEmpty()
  @IsEmail()
  @ApiProperty({
    description: "Target email for account deletion",
  })
  email: string;
}

export class DeletionFinishRequest {
  @IsString()
  @MinLength(16)
  @ApiProperty({
    description: "Deletion token provided in the email letter",
  })
  deletionToken: string;
}
