import { ApiProperty } from "@nestjs/swagger";
import {
  IsEmail,
  IsNotEmpty,
  IsOptional,
  IsString,
  MinLength,
} from "class-validator";

export class ChangeAccessKeyRequest {
  @IsString()
  @IsNotEmpty()
  @MinLength(64)
  @ApiProperty({
    description: "Current access key",
  })
  currentAccessKey: string;

  @IsString()
  @IsNotEmpty()
  @MinLength(64)
  @ApiProperty({
    description: "New access key",
  })
  newAccessKey: string;

  @IsOptional()
  @IsString()
  @IsEmail()
  @ApiProperty({
    description: "New email address",
    required: false,
  })
  newEmail?: string;
}
