import {
  ArgumentsHost,
  Catch,
  ExceptionFilter,
  HttpException,
  HttpStatus,
  Logger,
} from "@nestjs/common";

@Catch()
export class HttpExceptionFilter implements ExceptionFilter {
  constructor(private readonly logger: Logger) {}

  catch(exception: any, host: ArgumentsHost) {
    const ctx = host.switchToHttp();
    const response = ctx.getResponse();

    const status =
      exception instanceof HttpException
        ? exception.getStatus()
        : HttpStatus.INTERNAL_SERVER_ERROR;

    let message =
      exception instanceof HttpException
        ? (exception.getResponse() as any)
        : exception.message || "Unknown error";

    if (
      typeof message == "object" &&
      typeof message.statusCode == "number" &&
      typeof message.message == "string"
    )
      message = message.message as string;

    if (
      status >= HttpStatus.INTERNAL_SERVER_ERROR &&
      message != "Request body is too large" &&
      message != "aborted"
    )
      this.logger.error(exception);

    response.status(status).send({
      statusCode: status,
      message,
    });
  }
}
