import * as crypto from "crypto";

export function hashAccessKey(accessKey: string): string {
  return crypto.createHash("sha256").update(accessKey).digest("base64");
}

export function hashEmailAddress(emailAddress: string): string {
  return crypto.createHash("sha256").update(emailAddress).digest("hex");
}
