import { MigrationInterface, QueryRunner } from "typeorm";

export class CreateStepCharge1661361764117 implements MigrationInterface {
  name = "CreateStepCharge1661361764117";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "step_charge" ("id" SERIAL NOT NULL, "chargedAt" TIMESTAMP NOT NULL DEFAULT now(), "amount" integer NOT NULL DEFAULT '0', "type" character varying(64) NOT NULL DEFAULT '', "description" character varying(256) NOT NULL DEFAULT '', "ownerId" character varying, CONSTRAINT "PK_1f34ad068adbb798a0992d7b509" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `ALTER TABLE "step_charge" ADD CONSTRAINT "FK_de06a8be5d30a925cbac586b8f1" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "step_charge" DROP CONSTRAINT "FK_de06a8be5d30a925cbac586b8f1"`,
    );
    await queryRunner.query(`DROP TABLE "step_charge"`);
  }
}
