import {MigrationInterface, QueryRunner} from "typeorm";

export class UpdateContestSubmission1653507248195 implements MigrationInterface {
    name = 'UpdateContestSubmission1653507248195'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user_submission" ADD "dataKey" character varying(256) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD "dataName" character varying(256) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD "event" character varying(256) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD "socials" character varying(4096) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD "mediums" character varying(4096) NOT NULL DEFAULT ''`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP CONSTRAINT "REL_e17c66b3e512fe28aff83208cf"`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD CONSTRAINT "submission" UNIQUE ("authorEmail", "event")`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "user_submission" DROP CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP CONSTRAINT "submission"`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD CONSTRAINT "REL_e17c66b3e512fe28aff83208cf" UNIQUE ("ownerId")`);
        await queryRunner.query(`ALTER TABLE "user_submission" ADD CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP COLUMN "mediums"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP COLUMN "socials"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP COLUMN "event"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP COLUMN "dataName"`);
        await queryRunner.query(`ALTER TABLE "user_submission" DROP COLUMN "dataKey"`);
    }

}
