import {MigrationInterface, QueryRunner} from "typeorm";

export class AddGiftKeyReferrer1650394846142 implements MigrationInterface {
    name = 'AddGiftKeyReferrer1650394846142'

    public async up(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "subscription" ADD "referrerId" character varying`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp(0)`);
        await queryRunner.query(`ALTER TABLE "subscription" ADD CONSTRAINT "FK_b51548b8e3c0cac9c21c5ca83aa" FOREIGN KEY ("referrerId") REFERENCES "user"("id") ON DELETE SET NULL ON UPDATE NO ACTION`);
    }

    public async down(queryRunner: QueryRunner): Promise<void> {
        await queryRunner.query(`ALTER TABLE "subscription" DROP CONSTRAINT "FK_b51548b8e3c0cac9c21c5ca83aa"`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "deletionSessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "emailVerificationLastSentAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0))`);
        await queryRunner.query(`ALTER TABLE "subscription" DROP COLUMN "referrerId"`);
    }

}
