import { MigrationInterface, QueryRunner } from "typeorm";

export class UserSubmissionVoteFixRelation1635349795435
  implements MigrationInterface {
  name = "UserSubmissionVoteFixRelation1635349795435";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" DROP CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" DROP CONSTRAINT "REL_cb6ccf052c8b01efb31d8f96e1"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" ADD CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" DROP CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" ADD CONSTRAINT "REL_cb6ccf052c8b01efb31d8f96e1" UNIQUE ("ownerId")`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" ADD CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }
}
