import { MigrationInterface, QueryRunner } from "typeorm";

export class AddUserSubmissionVote1635348900924 implements MigrationInterface {
  name = "AddUserSubmissionVote1635348900924";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "user_submission_vote" ("id" character varying NOT NULL, "lastUpdatedAt" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, "submissionId" character varying(64) NOT NULL, "ownerId" character varying, CONSTRAINT "REL_cb6ccf052c8b01efb31d8f96e1" UNIQUE ("ownerId"), CONSTRAINT "PK_e849640d3ae5faaabd68327df7c" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" ADD CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user_submission_vote" DROP CONSTRAINT "FK_cb6ccf052c8b01efb31d8f96e14"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(`DROP TABLE "user_submission_vote"`);
  }
}
