import { MigrationInterface, QueryRunner } from "typeorm";

export class AddUserSubmission1634964849735 implements MigrationInterface {
  name = "AddUserSubmission1634964849735";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "user_submission" ("id" character varying NOT NULL, "lastUpdatedAt" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, "data" bytea, "authorName" character varying(256) NOT NULL DEFAULT '', "authorEmail" character varying(256) NOT NULL DEFAULT '', "ownerId" character varying, CONSTRAINT "REL_e17c66b3e512fe28aff83208cf" UNIQUE ("ownerId"), CONSTRAINT "PK_3c238e9d81e006b65ad4cac2fda" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user_submission" ADD CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user_submission" DROP CONSTRAINT "FK_e17c66b3e512fe28aff83208cfe"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "recoverySessionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(`DROP TABLE "user_submission"`);
  }
}
