import { MigrationInterface, QueryRunner } from "typeorm";

export class AddUserB2BFields1628701186647 implements MigrationInterface {
  name = "AddUserB2BFields1628701186647";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ADD "userType" integer NOT NULL DEFAULT '0'`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ADD "persistentAccessToken" character varying`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ADD "classificationCharactersLeft" integer NOT NULL DEFAULT '0'`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "classificationCharactersLeft"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "persistentAccessToken"`,
    );
    await queryRunner.query(`ALTER TABLE "user" DROP COLUMN "userType"`);
  }
}
