import { MigrationInterface, QueryRunner } from "typeorm";

export class AddAiModuleTrainingEntity1627217000680
  implements MigrationInterface {
  name = "AddAiModuleTrainingEntity1627217000680";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `CREATE TABLE "ai_training_module" ("id" character varying NOT NULL, "createdAt" TIMESTAMP NOT NULL DEFAULT now(), "lastUpdatedAt" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, "status" character varying NOT NULL DEFAULT 'pending', "data" bytea, "name" character varying(64) NOT NULL DEFAULT '', "description" character varying(256) NOT NULL DEFAULT '', "lr" real NOT NULL DEFAULT '1', "steps" integer NOT NULL DEFAULT '1', "ownerId" character varying, CONSTRAINT "PK_a0c8989e2c1a6f7c2b179edf607" PRIMARY KEY ("id"))`,
    );
    await queryRunner.query(
      `ALTER TABLE "ai_training_module" ADD CONSTRAINT "FK_8c5fbe032f6bee088ac96e86f19" FOREIGN KEY ("ownerId") REFERENCES "user"("id") ON DELETE CASCADE ON UPDATE NO ACTION`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "ai_training_module" DROP CONSTRAINT "FK_8c5fbe032f6bee088ac96e86f19"`,
    );
    await queryRunner.query(`DROP TABLE "ai_training_module"`);
  }
}
