import { MigrationInterface, QueryRunner } from "typeorm";

export class UserAddAccountRecoveryData1623947272143
  implements MigrationInterface {
  name = "UserAddAccountRecoveryData1623947272143";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ADD "recoverySessionToken" character varying`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ADD "recoverySessionUntil" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT to_timestamp(0)`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "recoverySessionUntil"`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "recoverySessionToken"`,
    );
  }
}
