import { MigrationInterface, QueryRunner } from "typeorm";

export class IncreaseUserDataMeta1623341741165 implements MigrationInterface {
  name = "IncreaseUserDataMeta1623341741165";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(`ALTER TABLE "userdata" DROP COLUMN "meta"`);
    await queryRunner.query(
      `ALTER TABLE "userdata" ADD "meta" character varying(128) NOT NULL DEFAULT ''`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(`ALTER TABLE "userdata" DROP COLUMN "meta"`);
    await queryRunner.query(
      `ALTER TABLE "userdata" ADD "meta" character varying(32) NOT NULL DEFAULT ''`,
    );
  }
}
