import { MigrationInterface, QueryRunner } from "typeorm";

export class UserAuthenticationNonce1622999127106
  implements MigrationInterface {
  name = "UserAuthenticationNonce1622999127106";

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ADD "authenticationNonce" character varying DEFAULT 'nonce'`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp(0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp(0)`,
    );
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "subscriptionUntil" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" ALTER COLUMN "nextRefillAt" SET DEFAULT to_timestamp((0)`,
    );
    await queryRunner.query(
      `ALTER TABLE "user" DROP COLUMN "authenticationNonce"`,
    );
  }
}
