import { User } from "../user/user.entity";
import {
  Column,
  Entity,
  JoinColumn,
  ManyToOne,
  PrimaryGeneratedColumn,
} from "typeorm";

@Entity("step_charge")
export class StepCharge {
  @PrimaryGeneratedColumn()
  id: number;

  @Column({ type: "timestamp", default: () => "CURRENT_TIMESTAMP" })
  chargedAt: Date;

  @Column({ type: "integer", default: 0 })
  amount: number;

  @Column({ default: "", length: 64 })
  type: string;

  @Column({ default: "", length: 256 })
  description: string;

  @ManyToOne(() => User, { onDelete: "CASCADE" })
  @JoinColumn()
  owner: User;
}
