package includes

import "fmt"

type APIEndpoint struct {
	URL     string   `json:"url"`
	Type    string   `json:"type"`
	Modules []string `json:"modules"`
}

type ImageGeneration struct {
	Prompt     string `json:"prompt"`
	IsEnhanced bool   `json:"is_enhanced"`
	// Base64 encoded image of the generation.
	Images []string `json:"image,omitempty"`
	// Only present if the generation is enhanced.
	OriginalGen *ImageGeneration `json:"previous_generation,omitempty"`
}
type ImageModel struct {
	Name            string `yaml:"Name"`
	Description     string `yaml:"Description"`
	APIEndpointUrl  string `yaml:"APIEndpointUrl"`
	ShortName       string `yaml:"ShortName"`
	ModuleSupport   bool   `yaml:"ModuleSupport"`
	AdvancedSupport bool   `yaml:"AdvancedSupport"`
}
type ImageGenerationRequest struct {
	Prompt string `json:"prompt"`
	// Sampling method
	Sampler string `json:"sampler"`
	// The number of generations to generate.
	NumGenerations int     `json:"n_samples"`
	Steps          int     `json:"steps"`
	Height         int     `json:"height"`
	Width          int     `json:"width"`
	Seed           int     `json:"seed"`
	Scale          int     `json:"scale"`
	Module         string  `json:"module"`
	Uc             string  `json:"uc,omitempty"`
	Strength       float64 `json:"strength,omitempty"`
	Noise          float64 `json:"noise,omitempty"`
	// the image should be PNG and base64 encoded
	Image string     `json:"image,omitempty"`
	Model ImageModel `json:"-"`
}

func (req ImageGenerationRequest) GetStr() string {
	if req.Uc == "" {
		return fmt.Sprintf("prompt: %s sampler: %s model: %s num_gen: %d steps: %d height: %d width: %d scale: %d seed: %d module: %s strength: %f noise: %f",
			req.Prompt, req.Sampler, req.Model.ShortName, req.NumGenerations, req.Steps, req.Height, req.Width, req.Scale, req.Seed, req.Module, req.Strength, req.Noise)
	} else {
		return fmt.Sprintf("prompt: %s uc: %s sampler: %s model: %s num_gen: %d steps: %d height: %d width: %d scale: %d seed: %d module: %s strength: %f noise: %f",
			req.Prompt, req.Uc, req.Sampler, req.Model.ShortName, req.NumGenerations, req.Steps, req.Height, req.Width, req.Scale, req.Seed, req.Module, req.Strength, req.Noise)
	}
}
