package gobot

import (
	"fmt"
	"log"
	"strconv"
	"strings"

	"github.com/bwmarrin/discordgo"
)

func GenerateDropdownOptions(min float64, max float64, skip float64, defaultOption float64) *[]discordgo.SelectMenuOption {
	var options = make([]discordgo.SelectMenuOption, 0)
	for i := min; i <= max; i += skip {
		options = append(options, discordgo.SelectMenuOption{
			Label:       fmt.Sprintf("%.2f", i),
			Value:       fmt.Sprintf("%.2f", i),
			Description: fmt.Sprintf("%.2f", i),
			Default:     i == defaultOption,
		})
	}
	return &options
}

func F64Ptr(f float64) *float64 { return &f }
func StrToF64(s string) float64 {
	f, err := strconv.ParseFloat(s, 64)
	if err != nil {
		return 0
	}
	return f
}

func StrToInt(s string) int {
	s = strings.ReplaceAll(s, ",", "")
	f, err := strconv.Atoi(s)
	if err != nil {
		return 0
	}
	return f
}

func ErrorHandler(err error, printToChat bool, s *discordgo.Session, i *discordgo.InteractionCreate) {
	if err != nil {
		log.Printf("Error: %v", err)
	}
	if printToChat {
		_, _ = s.ChannelMessageSend(i.ChannelID, fmt.Sprintf("Error: %v", err))
	}
}
