import os
from datacrunch import DataCrunchClient


f = open("datacrunchkey", "r")
CLIENT_SECRET = f.read().strip("\n")
CLIENT_ID = "5ft9OkC6u4s4rxGkYipVO"
global datacrunchx
global ssh_keys
dc_client = DataCrunchClient(CLIENT_ID, CLIENT_SECRET)
ssh_keys = dc_client.ssh_keys.get()
scripts = dc_client.startup_scripts.get()
#images = dc_client.images.get()


def launch_instance(instance_code, hostname):

    instance = dc_client.instances.create(
        instance_type=instance_code,
        image="ubuntu-20.04-cuda-11.0",
        ssh_key_ids=ssh_keys[0].id,
        hostname=hostname,
        description="example description",
        location="FIN1",
        startup_script_id=scripts[1].id
    )

    return instance


def destroy_instance(instance_id):
    # instance_id = instance.id
    dc_client.instances.action(instance_id, dc_client.actions.DELETE)
    return True


def is_available(instance_type: str) -> bool:
    return dc_client.instances.is_available(instance_type)


##############

def scaler_ok():
    return


# retard, why not return the instance NAME????????
def list_available_instances():
    instance_types = dc_client.instance_types.get()
    maclist = []
    for instance in instance_types:
        if instance.gpu["description"].split("NVidia ")[-1].split(" ")[-1] == "A6000":
            scaler_ok()
        else:
            gpu = instance.gpu["description"].split("NVidia ")[-1]
            num_gpus = instance.gpu["number_of_gpus"]
            # instance_type = ‘8V100.48M’
            instance_type = (
                str(num_gpus)
                + gpu.split(" ")[-1]
                + "."
                + instance.cpu["description"].split(" ")[0]
                + "V"
            )
            maclist.append(
                {
                    "gpu_name": gpu,
                    "provider": "datacrunch",
                    "num_gpus": num_gpus,
                    "dph_total": instance.price_per_hour,
                    "storage": instance.storage,
                    "memory": instance.memory,
                    "id": instance.id,
                    "cpu": instance.cpu,
                    "instance_type": instance_type
                }
            )
    return maclist


def list_my_instances():
    instances = dc_client.instances.get()
    maclist = []
    for instance in instances:
        #print(instance.price_per_hour)
        gpu = instance.gpu["description"].split("NVidia ")[-1]
        num_gpus = instance.gpu["number_of_gpus"]
        instance_type = (
            str(num_gpus)
            + gpu.split(" ")[-1]
            + "."
            + instance.cpu["description"].split(" ")[0]
            + "V"
        )
        maclist.append(
            {
                "gpu_name": gpu,
                "provider": "datacrunch",
                "num_gpus": num_gpus,
                "dph_total": instance.price_per_hour,
                "storage": instance.storage,
                "memory": instance.memory,
                "id": instance.id,
                "cpu": instance.cpu,
                "instance_type": instance_type,
                "dcinstance": instance
            }
        )

    return maclist

#launch_instance("1V100.6V", "maybe")