import time
import logging
from icecream import ic

from dotmap import DotMap
import torch

from lm_node.utils import *
from lm_node.sanitize import *
from lm_node.base import *
from termcolor import colored

# Setup logger
logger = logging.getLogger(__name__)
logger.setLevel(level=logging.INFO)
fh = logging.StreamHandler()
fh_formatter = logging.Formatter(
    "%(asctime)s %(levelname)s %(filename)s(%(process)d) - %(message)s"
)
fh.setFormatter(fh_formatter)
logger.addHandler(fh)

#Get environment variables from kubernetes config to load the model.
config = DotMap()
config.model_type = "GPT"

config.model_path = "/models/j6b_ckpt_14001"
config.model_name = "6B-v3" #2.7B, 6B, 6B-v3
config.prefix_path = "/models/defaultmodules"
config.user_module_path = "/usermodules"
config.deepspeed_enabled = False

config.logger = logger

load_time = time.time()

t = time.perf_counter()
if config.model_type == "GPT":
    model = GPTModel(config)
elif config.model_type == "VQGAN":
    model = VQGANModel(config)
t = time.perf_counter()
ic(time.perf_counter() - t)

f = open("/tmp/health_startup", "w")
f.close()
logger.info("Models loaded in {:.2f} seconds".format(time.time()-load_time))

def sample():
    text = """Nestled between the winding dunes of the Red Desert laid the fabled Grey Dragon dojo, home of Master Misashi, the greatest martial artist in the east and accomplished sorcerer.
    Although access to its grounds was usually highly restrictive this was a special occasion. The old master had sent out an invitation to any warrior who wanted to come and prove their worth in a grand tournament; whoever was crowned champion would be granted a single wish.
    The Grey Dragons believed that struggle was the key to self-improvement, therefore, it only made sense for them to live in such an arid wasteland. A place where the days were too hot and the nights were too cold; where water was a precious commodity—simply showing up at its gates meant you had passed the first test.
    The challenge and excitement surrounding the event meant that there was no shortage of contestants seeking to test their might, a crowd of muscle-bound fighters gathered under the shade of an awning above the entrance. Fortunately, the sun seemed to be doing a poor job, giving a weak, muted glow over the expanse, as if it was ashamed of how it was scorching the sands with its fiery rays.
    I arrived with nothing more than the clothes on my back and a mean attitude—enough to take on the world.
    Together with the rest of the group I entered the legendary monastery and made my way to the arena grounds. As we entered we were welcomed by Misashi himself, a wrinkled old man draped in a monk attire.
    "Ahh, it's so good to see so many young combatants attending the tournament!" Misashi began while stroking his long, white beard "The rules are simple: only unarmed combat is allowed, defeat your opponent and you'll pass to the next stage, losers will be eliminated, only one will have the honor of facing the grand champion."
    The dojo's arena was as bare as the desert, a square platform made out of smooth tiles built over the sands, the courtyard was spared the slightest of breezes by walls of limestone. With all eyes turned towards me I stepped up, the clacking of wooden sandals against the surface marking my entrance.
    "Begin!" said Misashi right before the thundering boom of a brass gong reverberated across the roofless arena, signaling the start of the duel.
    I looked up, past the brim of my straw hat to get a good look at my opponent. A certain strange detail stood out about him in particular,"""

    text2 = "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"
    text3 = "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"
    text4 = """You are a genie. Your powers are infinite except for the pesky detail that you are bound to serve your every master’s three wishes before you can return to your own little world and live life in peace.
One day you are torn out of the comfort of your magical lamp.

Before you stands your new master. His eyes sparkle with a mischievous light. 
You take a deep breath, gather your composure, and strike your most imposing stance. “You touched the lamp, and I will now bestow upon you three wishes.”
There is a moment of silence before your master looks you up and down.
You float in the air before him with shimmering magics and repeat, “What is your first wish?”
Your new master laughs before replying...

For his first wish, he wishes for a strong army to help him conquer the world. You offer no opinion on this wish but instead grant it immediately with a quick flash of purple lightning. He picks up his sword and shield from the table and shouts, “Now we go to war, follow me, soldiers!”

You cross your arms and follow your new master. 
“So, what is your second wish?”
He grins, looks you in the eye, and says, “I wish to be ruler of this land!”
You smirk in return and grant this wish too. Soon you are hurrying after your master as his armies march down the road, villages scatter at the sight of him. 
The rulers of the land fall before his army as he massacres his way to total control. 

You watch as he murders someone, tired of the sight. "Is this really all you enjoy doing?" You sigh, slightly exasperated.
His response is but a wild laugh then he returns to the royal palace. He climbs the dais to his throne before he turns to you and beams down at you, “This is just the start!” 
You frown and shrug, “Hmm, well, whatever makes you happy I suppose. What would be your third wish?”

The man thinks for a moment, before saying "I wish for you to stay here, with me. To remain with me for all eternity.”
You look away, not wanting to make eye contact. You turn around and head back to your lamp. Before you reach it, however, you stop and think for a moment. You lift your hand and touch the lamp, causing the flame to flicker. A bright purple glow envelops the room and your new master looks at you in surprise.
"Well, if you insist," you say, turning back to him. "But you must promise me one thing."
“Anything,” he replies eagerly."""
    #print("Prompt:\n" + text + "\n")
    tokens = torch.tensor([model.tokenizer(text).input_ids])
    #use_cache makes generation much faster by caching the attention matrices, always keep it on.
    req_params = {
        #"get_hidden_states": True
        #"top_k": 200,
        #"top_p": 0.7,
        #"top_a": 1.0,
        "temperature": 0.8,
        "min_length": 1,
        'max_length': 15,
        'num_logprobs': 10,
        #'repetition_penalty': 1.3,
        #"repetition_penalty_range": 2,
        #'repetition_penalty_range': 500,
        #'tail_free_sampling': 1,
        #'eos_token_id': 13,
        "top_k":140,"top_p":0.9,"tail_free_sampling":1,"repetition_penalty":1.1875,"repetition_penalty_range":1024,"repetition_penalty_slope":6.57,
        "pad_token_id": model.tokenizer.eos_token_id,
        "use_cache": True,
        "do_sample": True,
        "generate_until_sentence": True,
        "bad_word_ids": [[58]],
        "logit_bias_exp": [{"sequence": [1332], "bias": 10, "generate_once": False}]
        #"bad_words_ids": [[58], [60], [90], [92], [685], [1391], [1782], [2361], [3693], [4083], [4357], [4895], [5512], [5974], [7131], [8183], [8351], [8762], [8964], [8973], [9063], [11208], [11709], [11907], [11919], [12878], [12962], [13018], [13412], [14631], [14692], [14980], [15090], [15437], [16151], [16410], [16589], [17241], [17414], [17635], [17816], [17912], [18083], [18161], [18477], [19629], [19779], [19953], [20520], [20598], [20662], [20740], [21476], [21737], [22133], [22241], [22345], [22935], [23330], [23785], [23834], [23884], [25295], [25597], [25719], [25787], [25915], [26076], [26358], [26398], [26894], [26933], [27007], [27422], [28013], [29164], [29225], [29342], [29565], [29795], [30072], [30109], [30138], [30866], [31161], [31478], [32092], [32239], [32509], [33116], [33250], [33761], [34171], [34758], [34949], [35944], [36338], [36463], [36563], [36786], [36796], [36937], [37250], [37913], [37981], [38165], [38362], [38381], [38430], [38892], [39850], [39893], [41832], [41888], [42535], [42669], [42785], [42924], [43839], [44438], [44587], [44926], [45144], [45297], [46110], [46570], [46581], [46956], [47175], [47182], [47527], [47715], [48600], [48683], [48688], [48874], [48999], [49074], [49082], [49146], [49946], [10221], [4841], [1427], [2602, 834], [29343], [37405], [35780], [2602], [17202], [8162], [50256]],
        #"prefix": '6B-v3:fe2354cef8af4328ad779635e0a02d7b114016b3ea70de27d049b52353493427:6a0ce11330871894ee8ee4e9cb8c33efd2f7f1409842515f33b643ef6a0efa16',
    }
    req_dict = DotMap()
    req_dict.input = '"I wanted to'
    req_dict.parameters = DotMap(req_params)
    output = process_payload(req_dict,
                             config,
                             True,
                             model)
    if output[0]: #success
        ic()
        req_dict, warning = output
    else:
        ic(output[1])

    ic(req_dict)
    total_time = 0
    for _ in range(1):
        curr_time = time.perf_counter()
        generated_text = model.generate(req_dict.input, req_params=req_dict.parameters, use_string=True)
        time_delta = time.perf_counter() - curr_time
        ic(time_delta)
        total_time += time_delta
        ic(generated_text)

    ic(total_time / 5)

    print(colored(text4, "white"), colored(generated_text, "green"))

def main():
    sample()

if __name__ == "__main__":
    main()
    pass
