## 📝 Table of Contents

- [About](#about)
- [Getting Started](#getting_started)
- [Running the Tests](#tests)
- [Usage](#usage)
- [Deployment](#deployment)
- [IDE Configuration](#ide_configuration)

## About <a name = "about"></a>

Hydra-Node is primarily used as the inference nodes for [goose.ai](goose.ai) that run the various
models for performing completions.  When deployed these nodes are setup using knative to scale based
on the number of requests coming from [goose-middleware](https://github.com/gooseai/goose-middleware).
  Additionally, `hydra-node` contains code for performing a few other tasks (TODO explain).

## Getting Started <a name = "getting_started"></a>

These instructions will get you a copy of the project up and running on your local machine for 
development and testing purposes. See [Deployment](#deployment) for notes on how to deploy the 
project on a live system.

### Prerequisites

The following items are needed to develop Convey-Bridge:
- [python](https://www.python.org/) >= 3.8
- [Docker](https://docs.docker.com/get-started/) - for running images locally
- Docker account with access to [gooseai](https://hub.docker.com/orgs/gooseai)

It is recommended to use ssh cloning with this project for `git`, although `https` does appear to 
work.  To force ssh (for github) put the following in your `.gitconfig`:

```ini
[url "ssh://git@github.com/"]
  insteadOf = https://github.com/
```

### Setup
After all the prerequisites are installed and available, this project can be setup by the following:

```shell
git clone git@github.com:gooseai/hydra-node.git
cd hydra-node
git submodule update --init
python -m venv .venv
source .venv/bin/activate
pip install -r requirements.txt
```

If pytorch is not setup globally on the system then it can be installed in the virtual environment.  

```shell
pip install torch=1.10.1
```

*Note: This does require this specific version at this time, and newer versions cause issues.*

This will have the project setup to then run locally (see [Usage](#usage)).

Images can be built locally by running `build-image-dev.sh` and then run with `docker`:

## 🔧 Running the Tests <a name = "tests"></a>

The tests for this software can be run with `pytest`.  The tests currently consist of both unit and  
integration style tests, which perform requests against `hydra-node`.  To run the integration tests
an instance of `hydra-node` needs to be running at `localhost:50051` and properly configured per the
[Usage](#usage) section.

*NOTE: [test_models.py](./tests/test_models.py) requires additional files to be setup for the model
in order to run.*

## 🎈 Usage <a name="usage"></a>

When running both deployed and locally `hydra-node` loads configuration settings from the
environment.  The following settings can be set from the environment for `gprc_server.py` (defaults
shown):

```shell
GRPC_MAX_WORKERS=16
PORT=50051
GRPC_BIND=0.0.0.0:$PORT
PAUSE
DUMMY=False
DUMP_REQUESTS=False
```
Additionally the lm_node configuration requires a few additional options, of particular note are the
following:

```shell
MODEL_MAX_TOKENS=2048
MODEL_PATH=
MODEL_URI=
```

*NOTE: one of `MODEL_PATH` or `MODEL_URI` must be set.*

Once the environment variables are setup to match what is needed, the application can be run as:

```shell
python grpc_server.py
```

### Other usage

**TODO additional documentation for other commands such as `main.py`, `local.py`, `trainer_node.py`,
etc. if they are still applicable.** 

## 🚀 Deployment <a name = "deployment"></a>

The best way to deploy this for testing in a live environment is to use the Skaffold configuration 
in [gooseai/goose-kubeconf](https://github.com/gooseai/goose-kubeconf).  Instructions on how to use 
that can be found in that repo.

## ⌨️ IDE Configuration <a name = "ide_configuration"></a>

The following are some suggestions for setting up your IDE of choice, both 
[VS Code](https://code.visualstudio.com/) and [PyCharm](https://www.jetbrains.com/pycharm/) are 
currently being used with this project.

### VS Code

This repository contains recommendations for extensions to install, for best experience those should 
be installed.  In addition, settings for the project are set in [settings.json](.vscode/settings.json).

For testing and running with the debug configuration in [launch.json](.vscode/launch.json), VS Code 
will load environment variables from `local.env`, it is recommended to create this file following 
the [Usage](#usage) instructions and [Running the Tests](#tests) sections.
