/* eslint-disable @next/next/no-img-element */

import { NextPage } from 'next'
import { Block, Column, DESKTOP_LARGE, Grid, MaskImage, MOBILE_LARGE, PrimaryContent, Row, RowFull, SecondaryContent, Space, TABLET_SMALL } from '../../components/common'
import { useRef } from 'react'
import styled from 'styled-components'
import Handshake from '../../assets/icons/handshake.svg';
import ArrowRightSmall from '../../assets/icons/arrow-right-small.svg';
import { useRouter } from 'next/router';
import { openings } from '../jobs';
import Link from 'next/link';
import { AltColorButton, AltColorButtonLink, Button } from '../../components/button';
import { useWindowSize } from '../../hooks/useWindowSize';


const JobContent = styled.div`
    @media (min-width: ${DESKTOP_LARGE}px) {
        position: absolute;
        left:0;
        right:0;
        margin:0 auto;
        width: 100%;
    }
`

const Job: NextPage = () => {
    const contentRef = useRef<HTMLDivElement>(null)
    const router = useRouter()
    const job = openings.get((router.query.id ?? '') as string)
    const window = useWindowSize()
    return (
        <>
            <PrimaryContent >
                <Grid columns={['max-content', 'auto']} gap={108} style={{ alignItems: 'flex-start' }} className={'altFont'} breakpoints={[{ width: TABLET_SMALL, columns: 1, gap: 30 }]}>
                    <div>
                        <Link href='/jobs#openings'>
                            <a style={{ fontWeight: 400, fontSize: '24px', lineHeight: '55px' }}>&lt; Back to Jobs</a>
                        </Link>
                    </div>
                    <JobContent style={{ maxWidth: 900 }}>
                        <RowFull style={{gap:30}}>
                            <h1 className={'altFont altColor'} style={{ maxWidth: 560 }}>{job?.name}</h1>
                            {window.width > MOBILE_LARGE && <AltColorButtonLink style={{flex: '0 0 auto'}}>Apply for this Position</AltColorButtonLink>}

                        </RowFull>
                        <Space height={20} />
                        <p style={{ fontSize: '18px', lineHeight: '24px' }}>
                            {job?.description}
                        </p>
                        <Space height={60} />
                        <h3 style={{ fontWeight: 700 }}>Your Responsibilities</h3>
                        <Space height={20} />
                        <p>{job?.responsibilities}</p>
                        <Space height={40} />
                        <h3 style={{ fontWeight: 700 }}>What We’re Looking For</h3>
                        <Space height={20} />
                        <p>{job?.lookingFor}</p>
                        <Space height={40} />
                        <h3 style={{ fontWeight: 700 }}>Bonus Points</h3>
                        <Space height={20} />
                        <ul>
                            {job?.bonus.map((bonus, index) => (
                                <li key={index}>{bonus}</li>
                            ))}
                        </ul>
                        <Space height={40} />
                        {window.width <= MOBILE_LARGE && <AltColorButtonLink style={{flex: '0 0 auto'}}>Apply for this Position</AltColorButtonLink>}
                    </JobContent>
                </Grid>
            </PrimaryContent>
        </>
    )
}

export default Job
