/**
 * @file apps/terminal-font.h
 * @brief Fallback font used to render text where the TrueType renderer would be inappropriate.
 *
 * Used variously by Terminal, splash-log, and the kernel.
 *
 * This is baked bitmap version of Deja Vu Sans Mono.
 *
 * @copyright
 * Fonts are (c) Bitstream (see below). DejaVu changes are in public domain.
 *
 * Bitstream Vera Fonts Copyright
 * ------------------------------
 *
 * Copyright (c) 2003 by Bitstream, Inc. All Rights Reserved. Bitstream Vera is a trademark of Bitstream, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of the fonts accompanying this
 * license ("Fonts") and associated documentation files (the "Font Software"), to reproduce and distribute the
 * Font Software, including without limitation the rights to use, copy, merge, publish, distribute, and/or sell
 * copies of the Font Software, and to permit persons to whom the Font Software is furnished to do so, subject
 * to the following conditions:
 *
 * The above copyright and trademark notices and this permission notice shall be included in all copies of one
 * or more of the Font Software typefaces.
 *
 * The Font Software may be modified, altered, or added to, and in particular the designs of glyphs or
 * characters in the Fonts may be modified and additional glyphs or  or characters may be added to the Fonts,
 * only if the fonts are renamed to names not containing either the words "Bitstream" or the word "Vera".
 *
 * This License becomes null and void to the extent applicable to Fonts or Font Software that has been modified
 * and is distributed under the "Bitstream Vera" names.
 *
 * The Font Software may be sold as part of a larger software package but no copy of one or more of the Font
 * Software typefaces may be sold by itself.
 *
 * THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
 * LIMITED TO ANY WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF COPYRIGHT,
 * PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL BITSTREAM OR THE GNOME FOUNDATION BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF THE USE OR INABILITY TO USE THE FONT
 * SOFTWARE OR FROM OTHER DEALINGS IN THE FONT SOFTWARE.
 *
 * Except as contained in this notice, the names of Gnome, the Gnome Foundation, and Bitstream Inc., shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings in this Font Software without prior
 * written authorization from the Gnome Foundation or Bitstream Inc., respectively. For further information,
 * contact: fonts at gnome dot org.
 */
#define LARGE_FONT_CELL_WIDTH 8
#define LARGE_FONT_CELL_HEIGHT 17
#define LARGE_FONT_MASK 7
uint16_t large_font[][17] = {
	/* 0 32 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 1 9786 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*  #    #  */
		/* # #  # # */
		/* # #  # # */
		/* #  ## #  */
		/*  #    #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x42,
		0xa5,
		0xa5,
		0x9a,
		0x42,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 2 9787 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*  # ## #  */
		/* ## ## ## */
		/* ######## */
		/* ## ## #  */
		/*  ######  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x5a,
		0xdb,
		0xff,
		0xda,
		0x7e,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 3 9829 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##  ##  */
		/* ######## */
		/* ######## */
		/* ######## */
		/*  ######  */
		/*   ####   */
		/*    ##    */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x66,
		0xff,
		0xff,
		0xff,
		0x7e,
		0x3c,
		0x18,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 4 9830 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ####   */
		/*  #####   */
		/*  ######  */
		/*   ####   */
		/*    ##    */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x3c,
		0x7c,
		0x7e,
		0x3c,
		0x18,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 5 9827 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ####   */
		/*   ####   */
		/*    ##    */
		/*  ######  */
		/* ######## */
		/*  ## ###  */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x3c,
		0x3c,
		0x18,
		0x7e,
		0xff,
		0x6e,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 6 9824 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ###    */
		/*   ####   */
		/*  ######  */
		/*  ######  */
		/*  ### ##  */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x38,
		0x3c,
		0x7e,
		0x7e,
		0x76,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 7 8226 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ####   */
		/*   ####   */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x3c,
		0x3c,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 8 9688 */
	{
		/*          */
		/*          */
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ###  ### */
		/* ##    ## */
		/* ##    ## */
		/* ###  ### */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0xff,
		0xff,
		0xff,
		0xe7,
		0xc3,
		0xc3,
		0xe7,
		0xff,
		0xff,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 9 9675 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  #    #  */
		/* #      # */
		/* #      # */
		/* #      # */
		/* #     #  */
		/*  ##  ##  */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x42,
		0x81,
		0x81,
		0x81,
		0x82,
		0x66,
		0x18,
		0x00,
		0x00,
		0x00,
	},
	/* 10 9689 */
	{
		/*          */
		/*          */
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ##    ## */
		/* # #### # */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ###### # */
		/* #  ##  # */
		/* ### #### */
		/* ######## */
		/* ######## */
		/*          */
		0x00,
		0x00,
		0x00,
		0xff,
		0xff,
		0xff,
		0xc3,
		0xbd,
		0xff,
		0xff,
		0xff,
		0xfd,
		0x99,
		0xef,
		0xff,
		0xff,
		0x00,
	},
	/* 11 9794 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*      ### */
		/*   #  # # */
		/*  # ##    */
		/* #    #   */
		/* #    #   */
		/* #   #    */
		/*  ####    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x07,
		0x25,
		0x58,
		0x84,
		0x84,
		0x88,
		0x78,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 12 9792 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*   ####   */
		/*    #     */
		/*    #     */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x42,
		0x42,
		0x42,
		0x3c,
		0x10,
		0x10,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 13 9834 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    # ##  */
		/*    #  #  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  ###     */
		/*  ###     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x08,
		0x16,
		0x12,
		0x10,
		0x10,
		0x10,
		0x10,
		0x70,
		0x70,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 14 9835 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   # ###  */
		/*   #   #  */
		/*   #   #  */
		/*   #   #  */
		/*   #   #  */
		/*   #   #  */
		/*  ##   #  */
		/*  ##  ##  */
		/*      ##  */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x2e,
		0x22,
		0x22,
		0x22,
		0x22,
		0x22,
		0x62,
		0x66,
		0x06,
		0x00,
		0x00,
		0x00,
	},
	/* 15 9788 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*   #  #   */
		/*   ###    */
		/* # #  ##  */
		/*    ###   */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x24,
		0x38,
		0xa6,
		0x1c,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 16 9658 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* #        */
		/* ####     */
		/* #######  */
		/* #####    */
		/* ##       */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x80,
		0xf0,
		0xfe,
		0xf8,
		0xc0,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 17 9668 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*        # */
		/*    ##### */
		/* ######## */
		/*    ##### */
		/*       ## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x01,
		0x1f,
		0xff,
		0x1f,
		0x03,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 18 8597 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ## #   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*   ## #   */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x34,
		0x10,
		0x10,
		0x10,
		0x34,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 19 8252 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #   #   */
		/*  #   #   */
		/*  #   #   */
		/*  #   #   */
		/*  #   #   */
		/*  #   #   */
		/*          */
		/*  #   #   */
		/*  #   #   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x44,
		0x44,
		0x44,
		0x44,
		0x44,
		0x44,
		0x00,
		0x44,
		0x44,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 20 182 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###### */
		/*  ##### # */
		/*  ##### # */
		/*  ##### # */
		/*    ### # */
		/*      # # */
		/*      # # */
		/*      # # */
		/*      # # */
		/*      # # */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3f,
		0x7d,
		0x7d,
		0x7d,
		0x1d,
		0x05,
		0x05,
		0x05,
		0x05,
		0x05,
		0x00,
		0x00,
		0x00,
	},
	/* 21 167 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  #       */
		/*  ##      */
		/*  # ##    */
		/*  #  ##   */
		/*  ##  #   */
		/*   ## #   */
		/*     ##   */
		/*      #   */
		/*  ####    */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x40,
		0x60,
		0x58,
		0x4c,
		0x64,
		0x34,
		0x0c,
		0x04,
		0x78,
		0x00,
		0x00,
		0x00,
	},
	/* 22 9644 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0xff,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 23 8616 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ## #   */
		/*    #     */
		/*    #     */
		/*   ## #   */
		/*    ##    */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x34,
		0x10,
		0x10,
		0x34,
		0x18,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 24 8593 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ## #   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x34,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 25 8595 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*   ## #   */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x34,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 26 8594 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*      #   */
		/*       #  */
		/* #######  */
		/*      ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x04,
		0x02,
		0xfe,
		0x06,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 27 8592 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #       */
		/* #######  */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x40,
		0xfe,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 28 8735 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ######  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x7e,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 29 8596 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*      #   */
		/*  #    #  */
		/* #######  */
		/*  #   ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x04,
		0x42,
		0xfe,
		0x46,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 30 9650 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    ##    */
		/*    ##    */
		/*   ####   */
		/*   ####   */
		/*  ######  */
		/*  ######  */
		/* ######## */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x18,
		0x18,
		0x3c,
		0x3c,
		0x7e,
		0x7e,
		0xff,
		0x00,
		0x00,
		0x00,
	},
	/* 31 9660 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* #######  */
		/*  ######  */
		/*  #####   */
		/*   ####   */
		/*   ###    */
		/*    ##    */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xfe,
		0x7e,
		0x7c,
		0x3c,
		0x38,
		0x18,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 32 32 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 33 33 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 34 34 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 35 35 */
	{
		/*          */
		/*          */
		/*          */
		/*    #  #  */
		/*    #  #  */
		/*    # ##  */
		/*  ####### */
		/*   #  #   */
		/*   #  #   */
		/* #######  */
		/*   # #    */
		/*  #  #    */
		/*  #  #    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x12,
		0x12,
		0x16,
		0x7f,
		0x24,
		0x24,
		0xfe,
		0x28,
		0x48,
		0x48,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 36 36 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*   #####  */
		/*  #  #  # */
		/*  #  #    */
		/*   ###    */
		/*     ###  */
		/*     #  # */
		/*  #  #  # */
		/*   #####  */
		/*     #    */
		/*     #    */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x08,
		0x3e,
		0x49,
		0x48,
		0x38,
		0x0e,
		0x09,
		0x49,
		0x3e,
		0x08,
		0x08,
		0x00,
		0x00,
	},
	/* 37 37 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##      */
		/* #  #     */
		/* #  #     */
		/*  ##   #  */
		/*    ###   */
		/*  ##  ##  */
		/*     #  # */
		/*     #  # */
		/*      ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x60,
		0x90,
		0x90,
		0x62,
		0x1c,
		0x66,
		0x09,
		0x09,
		0x06,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 38 38 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #      */
		/*   #      */
		/*   ##     */
		/*  #  #  # */
		/*  #  ## # */
		/*  #   # # */
		/*  ##   #  */
		/*   #### # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x20,
		0x20,
		0x30,
		0x49,
		0x4d,
		0x45,
		0x62,
		0x3d,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 39 39 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 40 40 */
	{
		/*          */
		/*          */
		/*     ##   */
		/*     #    */
		/*     #    */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     #    */
		/*     #    */
		/*      #   */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x0c,
		0x08,
		0x08,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x08,
		0x08,
		0x04,
		0x00,
		0x00,
		0x00,
	},
	/* 41 41 */
	{
		/*          */
		/*          */
		/*   ##     */
		/*    #     */
		/*    #     */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*    #     */
		/*    #     */
		/*   ##     */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x30,
		0x10,
		0x10,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x10,
		0x10,
		0x30,
		0x00,
		0x00,
		0x00,
	},
	/* 42 42 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*  #  #  # */
		/*   #####  */
		/*    ###   */
		/*  ## # ## */
		/*     #    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x08,
		0x49,
		0x3e,
		0x1c,
		0x6b,
		0x08,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 43 43 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/* #######  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x10,
		0xfe,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 44 44 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*    #     */
		/*   #      */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x10,
		0x20,
		0x00,
		0x00,
	},
	/* 45 45 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x38,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 46 46 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 47 47 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*       #  */
		/*      #   */
		/*      #   */
		/*     #    */
		/*     #    */
		/*    ##    */
		/*    #     */
		/*    #     */
		/*   #      */
		/*   #      */
		/*  #       */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x02,
		0x04,
		0x04,
		0x08,
		0x08,
		0x18,
		0x10,
		0x10,
		0x20,
		0x20,
		0x40,
		0x00,
		0x00,
	},
	/* 48 48 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  #  #  # */
		/*  #     # */
		/*  #     # */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x49,
		0x41,
		0x41,
		0x22,
		0x1c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 49 49 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x38,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 50 50 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  #    ## */
		/*        # */
		/*        # */
		/*       #  */
		/*     ##   */
		/*    ##    */
		/*   #      */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x43,
		0x01,
		0x01,
		0x02,
		0x0c,
		0x18,
		0x20,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 51 51 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  #     # */
		/*        # */
		/*       ## */
		/*    ###   */
		/*       ## */
		/*        # */
		/*  #    ## */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x41,
		0x01,
		0x03,
		0x1c,
		0x03,
		0x01,
		0x43,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 52 52 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*      ##  */
		/*     # #  */
		/*    ## #  */
		/*    #  #  */
		/*   #   #  */
		/*  #    #  */
		/*  ####### */
		/*       #  */
		/*       #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x06,
		0x0a,
		0x1a,
		0x12,
		0x22,
		0x42,
		0x7f,
		0x02,
		0x02,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 53 53 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  #       */
		/*  #       */
		/*  #####   */
		/*       ## */
		/*        # */
		/*        # */
		/*  #    ## */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x40,
		0x40,
		0x7c,
		0x03,
		0x01,
		0x01,
		0x43,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 54 54 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ####  */
		/*   #    # */
		/*  #       */
		/*  # ####  */
		/*  ##   ## */
		/*  #     # */
		/*  #     # */
		/*   #   ## */
		/*    ####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1e,
		0x21,
		0x40,
		0x5e,
		0x63,
		0x41,
		0x41,
		0x23,
		0x1e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 55 55 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*       #  */
		/*       #  */
		/*      #   */
		/*      #   */
		/*     #    */
		/*    ##    */
		/*    #     */
		/*   #      */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x02,
		0x02,
		0x04,
		0x04,
		0x08,
		0x18,
		0x10,
		0x20,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 56 56 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #####  */
		/*  ##   ## */
		/*  #     # */
		/*  ##    # */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x41,
		0x41,
		0x41,
		0x3e,
		0x63,
		0x41,
		0x61,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 57 57 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  ##   #  */
		/*  #     # */
		/*  #     # */
		/*  ##   ## */
		/*   #### # */
		/*        # */
		/*  #    #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x62,
		0x41,
		0x41,
		0x63,
		0x3d,
		0x01,
		0x42,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 58 58 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 59 59 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*    #     */
		/*   #      */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x10,
		0x20,
		0x00,
		0x00,
	},
	/* 60 60 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*        # */
		/*     ###  */
		/*  ###     */
		/*  ###     */
		/*     ###  */
		/*        # */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x01,
		0x0e,
		0x70,
		0x70,
		0x0e,
		0x01,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 61 61 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*          */
		/*          */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x00,
		0x00,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 62 62 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #       */
		/*   ###    */
		/*      ### */
		/*      ### */
		/*   ###    */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x40,
		0x38,
		0x07,
		0x07,
		0x38,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 63 63 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###    */
		/*  #   #   */
		/*      #   */
		/*     #    */
		/*    #     */
		/*    #     */
		/*          */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x38,
		0x44,
		0x04,
		0x08,
		0x10,
		0x10,
		0x00,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 64 64 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ####  */
		/*   ##  ## */
		/*   #    # */
		/*  #   ### */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*  #   ### */
		/*   #      */
		/*   ##     */
		/*    ####  */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1e,
		0x33,
		0x21,
		0x47,
		0x49,
		0x49,
		0x49,
		0x47,
		0x20,
		0x30,
		0x1e,
		0x00,
		0x00,
	},
	/* 65 65 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    # #   */
		/*    # #   */
		/*    # #   */
		/*   #   #  */
		/*   #   #  */
		/*   #####  */
		/*  ##   ## */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x08,
		0x14,
		0x14,
		0x14,
		0x22,
		0x22,
		0x3e,
		0x63,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 66 66 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  ######  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  ######  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x41,
		0x41,
		0x41,
		0x7e,
		0x41,
		0x41,
		0x41,
		0x7e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 67 67 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ####  */
		/*   #    # */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*   #    # */
		/*    ####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1e,
		0x21,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x21,
		0x1e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 68 68 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*  #    #  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #    #  */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x42,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x42,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 69 69 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 70 70 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 71 71 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ####  */
		/*   #    # */
		/*  #       */
		/*  #       */
		/*  #    ## */
		/*  #     # */
		/*  #     # */
		/*   #    # */
		/*    ####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1e,
		0x21,
		0x40,
		0x40,
		0x43,
		0x41,
		0x41,
		0x21,
		0x1e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 72 72 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  ####### */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x41,
		0x41,
		0x41,
		0x41,
		0x7f,
		0x41,
		0x41,
		0x41,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 73 73 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 74 74 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*      #   */
		/*      #   */
		/*      #   */
		/*      #   */
		/*      #   */
		/*      #   */
		/*  #   #   */
		/*   ###    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x04,
		0x04,
		0x04,
		0x04,
		0x04,
		0x04,
		0x44,
		0x38,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 75 75 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*  #   #   */
		/*  #  #    */
		/*  # #     */
		/*  ###     */
		/*  #  #    */
		/*  #   #   */
		/*  #   #   */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x44,
		0x48,
		0x50,
		0x70,
		0x48,
		0x44,
		0x44,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 76 76 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 77 77 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##   ## */
		/*  ##   ## */
		/*  # # # # */
		/*  # # # # */
		/*  # # # # */
		/*  #  #  # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x63,
		0x63,
		0x55,
		0x55,
		0x55,
		0x49,
		0x41,
		0x41,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 78 78 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##    # */
		/*  ##    # */
		/*  # #   # */
		/*  # #   # */
		/*  #  #  # */
		/*  #   # # */
		/*  #   # # */
		/*  #    ## */
		/*  #    ## */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x61,
		0x61,
		0x51,
		0x51,
		0x49,
		0x45,
		0x45,
		0x43,
		0x43,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 79 79 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x22,
		0x1c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 80 80 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  #    ## */
		/*  #     # */
		/*  #     # */
		/*  #    ## */
		/*  ######  */
		/*  #       */
		/*  #       */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x43,
		0x41,
		0x41,
		0x43,
		0x7e,
		0x40,
		0x40,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 81 81 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #   ## */
		/*    ####  */
		/*      ##  */
		/*       #  */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x23,
		0x1e,
		0x06,
		0x02,
		0x00,
		0x00,
	},
	/* 82 82 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  #    ## */
		/*  #     # */
		/*  #     # */
		/*  ######  */
		/*  #    #  */
		/*  #     # */
		/*  #     # */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x43,
		0x41,
		0x41,
		0x7e,
		0x42,
		0x41,
		0x41,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 83 83 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  ##    # */
		/*  #       */
		/*  ##      */
		/*   #####  */
		/*       ## */
		/*        # */
		/*  #    ## */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x61,
		0x40,
		0x60,
		0x3e,
		0x03,
		0x01,
		0x43,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 84 84 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/* #######  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0xfe,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 85 85 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 86 86 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #     # */
		/*  ##   ## */
		/*   #   #  */
		/*   #   #  */
		/*   #   #  */
		/*    # #   */
		/*    # #   */
		/*    # #   */
		/*     #    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x41,
		0x63,
		0x22,
		0x22,
		0x22,
		0x14,
		0x14,
		0x14,
		0x08,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 87 87 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/* #      # */
		/* #      # */
		/* #      # */
		/*  # ## #  */
		/*  # ## #  */
		/*  # ## #  */
		/*  ##  ##  */
		/*  ##  ##  */
		/*  ##  ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x81,
		0x81,
		0x81,
		0x5a,
		0x5a,
		0x5a,
		0x66,
		0x66,
		0x66,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 88 88 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##   ## */
		/*   #   #  */
		/*    # #   */
		/*    ###   */
		/*     #    */
		/*    # #   */
		/*   ## ##  */
		/*   #   #  */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x63,
		0x22,
		0x14,
		0x1c,
		0x08,
		0x14,
		0x36,
		0x22,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 89 89 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/* #     #  */
		/*  #   #   */
		/*   # #    */
		/*   # #    */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x82,
		0x44,
		0x28,
		0x28,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 90 90 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*       ## */
		/*      ##  */
		/*      #   */
		/*     #    */
		/*    #     */
		/*   ##     */
		/*  ##      */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x03,
		0x06,
		0x04,
		0x08,
		0x10,
		0x30,
		0x60,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 91 91 */
	{
		/*          */
		/*          */
		/*    ###   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x1c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x1c,
		0x00,
		0x00,
		0x00,
	},
	/* 92 92 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #       */
		/*   #      */
		/*   #      */
		/*    #     */
		/*    #     */
		/*    ##    */
		/*     #    */
		/*     #    */
		/*      #   */
		/*      #   */
		/*       #  */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x40,
		0x20,
		0x20,
		0x10,
		0x10,
		0x18,
		0x08,
		0x08,
		0x04,
		0x04,
		0x02,
		0x00,
		0x00,
	},
	/* 93 93 */
	{
		/*          */
		/*          */
		/*   ###    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*   ###    */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x38,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x38,
		0x00,
		0x00,
		0x00,
	},
	/* 94 94 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*   # #    */
		/*  #   #   */
		/* ##   ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x28,
		0x44,
		0xc6,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 95 95 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x00,
	},
	/* 96 96 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 97 97 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 98 98 */
	{
		/*          */
		/*          */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x40,
		0x40,
		0x40,
		0x40,
		0x7c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 99 99 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #       */
		/*  #       */
		/*  #       */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x40,
		0x40,
		0x40,
		0x22,
		0x1c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 100 100 */
	{
		/*          */
		/*          */
		/*       #  */
		/*       #  */
		/*       #  */
		/*       #  */
		/*   #####  */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x02,
		0x02,
		0x02,
		0x02,
		0x3e,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 101 101 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  ######  */
		/*  #       */
		/*  ##   #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x7e,
		0x40,
		0x62,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 102 102 */
	{
		/*          */
		/*          */
		/*     ##   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x0c,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 103 103 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ### #  */
		/*       #  */
		/*   #   #  */
		/*    ###   */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3a,
		0x02,
		0x22,
		0x1c,
		0x00,
	},
	/* 104 104 */
	{
		/*          */
		/*          */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  # ###   */
		/*  ##   #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x40,
		0x40,
		0x40,
		0x40,
		0x5c,
		0x62,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 105 105 */
	{
		/*          */
		/*          */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x10,
		0x00,
		0x00,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 106 106 */
	{
		/*          */
		/*          */
		/*     #    */
		/*          */
		/*          */
		/*          */
		/*   ###    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*     #    */
		/*  ###     */
		/*          */
		0x00,
		0x00,
		0x08,
		0x00,
		0x00,
		0x00,
		0x38,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x08,
		0x70,
		0x00,
	},
	/* 107 107 */
	{
		/*          */
		/*          */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #   #   */
		/*  #  #    */
		/*  # #     */
		/*  ###     */
		/*  #  #    */
		/*  #   #   */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x40,
		0x40,
		0x40,
		0x40,
		0x44,
		0x48,
		0x50,
		0x70,
		0x48,
		0x44,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 108 108 */
	{
		/*          */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     ###  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x0e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 109 109 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x49,
		0x49,
		0x49,
		0x49,
		0x49,
		0x49,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 110 110 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  # ###   */
		/*  ##   #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x5c,
		0x62,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 111 111 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 112 112 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*  #####   */
		/*  #       */
		/*  #       */
		/*  #       */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x7c,
		0x40,
		0x40,
		0x40,
		0x00,
	},
	/* 113 113 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ### #  */
		/*       #  */
		/*       #  */
		/*       #  */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3a,
		0x02,
		0x02,
		0x02,
		0x00,
	},
	/* 114 114 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*   ##  #  */
		/*   #      */
		/*   #      */
		/*   #      */
		/*   #      */
		/*   #      */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x32,
		0x20,
		0x20,
		0x20,
		0x20,
		0x20,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 115 115 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  #    #  */
		/*  #       */
		/*   ####   */
		/*       #  */
		/*  #    #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x42,
		0x40,
		0x3c,
		0x02,
		0x42,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 116 116 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*  ######  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     ###  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x7e,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x0e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 117 117 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 118 118 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*  ##  ##  */
		/*   #  #   */
		/*   #  #   */
		/*   ####   */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x66,
		0x24,
		0x24,
		0x3c,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 119 119 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* #      # */
		/* #      # */
		/*  # ## #  */
		/*  # ## #  */
		/*  # ## #  */
		/*   #  #   */
		/*   #  #   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x81,
		0x81,
		0x5a,
		0x5a,
		0x5a,
		0x24,
		0x24,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 120 120 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##  ##  */
		/*   #  #   */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*   #  #   */
		/*  ##  ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x66,
		0x24,
		0x18,
		0x18,
		0x18,
		0x24,
		0x66,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 121 121 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*   #   #  */
		/*   #  #   */
		/*   #  #   */
		/*    # #   */
		/*    ##    */
		/*     #    */
		/*     #    */
		/*    #     */
		/*   ##     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x22,
		0x24,
		0x24,
		0x14,
		0x18,
		0x08,
		0x08,
		0x10,
		0x30,
		0x00,
	},
	/* 122 122 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*       #  */
		/*      #   */
		/*    ##    */
		/*   #      */
		/*  #       */
		/*  ######  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x02,
		0x04,
		0x18,
		0x20,
		0x40,
		0x7e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 123 123 */
	{
		/*          */
		/*          */
		/*    ###   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  ##      */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     ##   */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x1c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x60,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x0c,
		0x00,
		0x00,
		0x00,
	},
	/* 124 124 */
	{
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		0x00,
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
	},
	/* 125 125 */
	{
		/*          */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     ##   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  ##      */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x0c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x60,
		0x00,
		0x00,
		0x00,
	},
	/* 126 126 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###  # */
		/*  #   ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x39,
		0x46,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 127 8962 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ######  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x42,
		0x42,
		0x42,
		0x42,
		0x7e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 128 199 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ####  */
		/*   #    # */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*   #    # */
		/*    ####  */
		/*      #   */
		/*      #   */
		/*    ###   */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1e,
		0x21,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x21,
		0x1e,
		0x04,
		0x04,
		0x1c,
		0x00,
	},
	/* 129 252 */
	{
		/*          */
		/*          */
		/*          */
		/*   #  #   */
		/*          */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x24,
		0x00,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 130 233 */
	{
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  ######  */
		/*  #       */
		/*  ##   #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x08,
		0x10,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x7e,
		0x40,
		0x62,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 131 226 */
	{
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 132 228 */
	{
		/*          */
		/*          */
		/*          */
		/*   # #    */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x28,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 133 224 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 134 229 */
	{
		/*          */
		/*    ##    */
		/*   #  #   */
		/*   #  #   */
		/*    ##    */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x18,
		0x24,
		0x24,
		0x18,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 135 231 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #       */
		/*  #       */
		/*  #       */
		/*   #   #  */
		/*    ###   */
		/*      #   */
		/*      #   */
		/*    ###   */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x40,
		0x40,
		0x40,
		0x22,
		0x1c,
		0x04,
		0x04,
		0x1c,
		0x00,
	},
	/* 136 234 */
	{
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  ######  */
		/*  #       */
		/*  ##   #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x7e,
		0x40,
		0x62,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 137 235 */
	{
		/*          */
		/*          */
		/*          */
		/*  #  #    */
		/*          */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  ######  */
		/*  #       */
		/*  ##   #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x48,
		0x00,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x7e,
		0x40,
		0x62,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 138 232 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  ######  */
		/*  #       */
		/*  ##   #  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x7e,
		0x40,
		0x62,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 139 239 */
	{
		/*          */
		/*          */
		/*          */
		/*   # #    */
		/*          */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x28,
		0x00,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 140 238 */
	{
		/*          */
		/*          */
		/*          */
		/*   ##     */
		/*  #  #    */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x30,
		0x48,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 141 236 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 142 196 */
	{
		/*          */
		/*          */
		/*    # #   */
		/*          */
		/*     #    */
		/*    # #   */
		/*    # #   */
		/*    # #   */
		/*   #   #  */
		/*   #   #  */
		/*   #####  */
		/*  ##   ## */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x14,
		0x00,
		0x08,
		0x14,
		0x14,
		0x14,
		0x22,
		0x22,
		0x3e,
		0x63,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 143 197 */
	{
		/*          */
		/*    ###   */
		/*    # #   */
		/*    # #   */
		/*     #    */
		/*     #    */
		/*    # #   */
		/*    # #   */
		/*    # #   */
		/*   #   #  */
		/*   #####  */
		/*   #   #  */
		/*  #     # */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x1c,
		0x14,
		0x14,
		0x08,
		0x08,
		0x14,
		0x14,
		0x14,
		0x22,
		0x3e,
		0x22,
		0x41,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 144 201 */
	{
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x08,
		0x10,
		0x00,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 145 230 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ## ##   */
		/*    #  #  */
		/*    #  #  */
		/*  ######  */
		/*  # #     */
		/*  # #     */
		/*  ## ###  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x6c,
		0x12,
		0x12,
		0x7e,
		0x50,
		0x50,
		0x6e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 146 198 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*  #  ###  */
		/*  #  #    */
		/*  ####    */
		/* #   #    */
		/* #   ###  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x28,
		0x28,
		0x28,
		0x4e,
		0x48,
		0x78,
		0x88,
		0x8e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 147 244 */
	{
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 148 246 */
	{
		/*          */
		/*          */
		/*          */
		/*   #  #   */
		/*          */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x24,
		0x00,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 149 242 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 150 251 */
	{
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 151 249 */
	{
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*     #    */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x10,
		0x08,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 152 255 */
	{
		/*          */
		/*          */
		/*          */
		/*   # #    */
		/*          */
		/*          */
		/*  #    #  */
		/*   #   #  */
		/*   #  #   */
		/*   #  #   */
		/*    # #   */
		/*    ##    */
		/*     #    */
		/*     #    */
		/*    #     */
		/*   ##     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x28,
		0x00,
		0x00,
		0x42,
		0x22,
		0x24,
		0x24,
		0x14,
		0x18,
		0x08,
		0x08,
		0x10,
		0x30,
		0x00,
	},
	/* 153 214 */
	{
		/*          */
		/*          */
		/*    # #   */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x14,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x22,
		0x1c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 154 220 */
	{
		/*          */
		/*          */
		/*    # #   */
		/*          */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x14,
		0x00,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x41,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 155 162 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*   ###    */
		/*  # # #   */
		/*  # #     */
		/*  # #     */
		/*  # #     */
		/*  # # #   */
		/*   ###    */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x38,
		0x54,
		0x50,
		0x50,
		0x50,
		0x54,
		0x38,
		0x10,
		0x10,
		0x00,
		0x00,
	},
	/* 156 163 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #      */
		/*   #      */
		/*   #      */
		/*  ####    */
		/*   #      */
		/*   #      */
		/*   #      */
		/* ######   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x20,
		0x20,
		0x20,
		0x78,
		0x20,
		0x20,
		0x20,
		0xfc,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 157 165 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/* #     #  */
		/*  #   #   */
		/*   # #    */
		/* ### ###  */
		/*    #     */
		/* #######  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x82,
		0x44,
		0x28,
		0xee,
		0x10,
		0xfe,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 158 8359 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/* ####     */
		/* # ##     */
		/* # ###### */
		/* # ## #   */
		/* #### #   */
		/* #  #  #  */
		/* #  #   # */
		/* #  #   # */
		/* #   ###  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0xf0,
		0xb0,
		0xbf,
		0xb4,
		0xf4,
		0x92,
		0x91,
		0x91,
		0x8e,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 159 402 */
	{
		/*          */
		/*          */
		/*          */
		/*     ###  */
		/*    #     */
		/*    #     */
		/*  ######  */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*   #      */
		/*          */
		0x00,
		0x00,
		0x00,
		0x0e,
		0x10,
		0x10,
		0x7e,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x20,
		0x00,
	},
	/* 160 225 */
	{
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*       #  */
		/*   #####  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x08,
		0x10,
		0x00,
		0x1c,
		0x22,
		0x02,
		0x3e,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 161 237 */
	{
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*  ###     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  #####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x08,
		0x10,
		0x00,
		0x70,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x7c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 162 243 */
	{
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x08,
		0x10,
		0x00,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 163 250 */
	{
		/*          */
		/*          */
		/*          */
		/*     #    */
		/*    #     */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*   ### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x08,
		0x10,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x3a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 164 241 */
	{
		/*          */
		/*          */
		/*          */
		/*   ## #   */
		/*   # ##   */
		/*          */
		/*  # ###   */
		/*  ##   #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x34,
		0x2c,
		0x00,
		0x5c,
		0x62,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 165 209 */
	{
		/*          */
		/*   ### #  */
		/*   # ###  */
		/*          */
		/*  ##    # */
		/*  ##    # */
		/*  # #   # */
		/*  # #   # */
		/*  #  #  # */
		/*  #   # # */
		/*  #   # # */
		/*  #    ## */
		/*  #    ## */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x3a,
		0x2e,
		0x00,
		0x61,
		0x61,
		0x51,
		0x51,
		0x49,
		0x45,
		0x45,
		0x43,
		0x43,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 166 170 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*       #  */
		/*    ####  */
		/*   #   #  */
		/*   #####  */
		/*          */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x02,
		0x1e,
		0x22,
		0x3e,
		0x00,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 167 186 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*   #   #  */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*   #####  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x22,
		0x22,
		0x1c,
		0x00,
		0x3e,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 168 191 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*          */
		/*    #     */
		/*    #     */
		/*   ##     */
		/*  ##      */
		/*  #       */
		/*  #   #   */
		/*   ###    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x00,
		0x10,
		0x10,
		0x30,
		0x60,
		0x40,
		0x44,
		0x38,
		0x00,
	},
	/* 169 8976 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  #       */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x40,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 170 172 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*        # */
		/*        # */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x01,
		0x01,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 171 189 */
	{
		/*          */
		/*          */
		/*          */
		/*  ##      */
		/*   #      */
		/*   #      */
		/*   #      */
		/*  ### ##  */
		/*   ###    */
		/* ##       */
		/*    ####  */
		/*       #  */
		/*      #   */
		/*     #    */
		/*    ####  */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x60,
		0x20,
		0x20,
		0x20,
		0x76,
		0x38,
		0xc0,
		0x1e,
		0x02,
		0x04,
		0x08,
		0x1e,
		0x00,
		0x00,
	},
	/* 172 188 */
	{
		/*          */
		/*          */
		/*          */
		/*  ##      */
		/*   #      */
		/*   #      */
		/*   #      */
		/*  ### ##  */
		/*   ###    */
		/* ##       */
		/*      #   */
		/*     ##   */
		/*    # #   */
		/*    ####  */
		/*      #   */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x60,
		0x20,
		0x20,
		0x20,
		0x76,
		0x38,
		0xc0,
		0x04,
		0x0c,
		0x14,
		0x1e,
		0x04,
		0x00,
		0x00,
	},
	/* 173 161 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
		0x00,
	},
	/* 174 171 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #  #  */
		/*   ## ##  */
		/*  ## ##   */
		/*  ## ##   */
		/*   ## ##  */
		/*    #  #  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x12,
		0x36,
		0x6c,
		0x6c,
		0x36,
		0x12,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 175 187 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #  #    */
		/*  ## ##   */
		/*   ## ##  */
		/*   ## ##  */
		/*  ## ##   */
		/*  #  #    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x48,
		0x6c,
		0x36,
		0x36,
		0x6c,
		0x48,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 176 9617 */
	{
		/*          */
		/* #   #    */
		/*          */
		/*   #   #  */
		/*          */
		/* #   #    */
		/*          */
		/*   #   #  */
		/*          */
		/* #   #    */
		/*          */
		/*   #   #  */
		/*          */
		/* #   #    */
		/*          */
		/*   #   #  */
		/*          */
		0x00,
		0x88,
		0x00,
		0x22,
		0x00,
		0x88,
		0x00,
		0x22,
		0x00,
		0x88,
		0x00,
		0x22,
		0x00,
		0x88,
		0x00,
		0x22,
		0x00,
	},
	/* 177 9618 */
	{
		/*          */
		/* #  # ##  */
		/*  ## #  # */
		/*  ## #  # */
		/* #  # ##  */
		/*  ## #  # */
		/*  ## #  # */
		/* #  # ##  */
		/* #  # ##  */
		/*  ## #  # */
		/* #  # ##  */
		/* #  # ##  */
		/*  ## #  # */
		/* #  # ##  */
		/* #  # ##  */
		/*  ## #  # */
		/*          */
		0x00,
		0x96,
		0x69,
		0x69,
		0x96,
		0x69,
		0x69,
		0x96,
		0x96,
		0x69,
		0x96,
		0x96,
		0x69,
		0x96,
		0x96,
		0x69,
		0x00,
	},
	/* 178 9619 */
	{
		/*          */
		/*  ### ### */
		/* ######## */
		/* ## ### # */
		/* ######## */
		/*  ### ### */
		/* ######## */
		/* ## ### # */
		/* ######## */
		/*  ### ### */
		/* ######## */
		/* ## ### # */
		/* ######## */
		/*  ### ### */
		/* ######## */
		/* ## ### # */
		/*          */
		0x00,
		0x77,
		0xff,
		0xdd,
		0xff,
		0x77,
		0xff,
		0xdd,
		0xff,
		0x77,
		0xff,
		0xdd,
		0xff,
		0x77,
		0xff,
		0xdd,
		0x00,
	},
	/* 179 9474 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 180 9508 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ####     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xf0,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 181 9569 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ####     */
		/*    #     */
		/* ####     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xf0,
		0x10,
		0xf0,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 182 9570 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ### #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xe8,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 183 9558 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* #####    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xf8,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 184 9557 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ####     */
		/*    #     */
		/* ####     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xf0,
		0x10,
		0xf0,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 185 9571 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ### #    */
		/*     #    */
		/* ### #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xe8,
		0x08,
		0xe8,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 186 9553 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 187 9559 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* #####    */
		/*     #    */
		/* ### #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xf8,
		0x08,
		0xe8,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 188 9565 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ### #    */
		/*     #    */
		/* #####    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xe8,
		0x08,
		0xf8,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 189 9564 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* #####    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xf8,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 190 9563 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ####     */
		/*    #     */
		/* ####     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xf0,
		0x10,
		0xf0,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 191 9488 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ####     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xf0,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 192 9492 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    ##### */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x1f,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 193 9524 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 194 9516 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 195 9500 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    ##### */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x1f,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 196 9472 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 197 9532 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ######## */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xff,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 198 9566 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    ##### */
		/*    #     */
		/*    ##### */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x1f,
		0x10,
		0x1f,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 199 9567 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x2f,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 200 9562 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #### */
		/*   #      */
		/*   ###### */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x2f,
		0x20,
		0x3f,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 201 9556 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###### */
		/*   #      */
		/*   # #### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3f,
		0x20,
		0x2f,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 202 9577 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ### #### */
		/*          */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xef,
		0x00,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 203 9574 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*          */
		/* ### #### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x00,
		0xef,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 204 9568 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #### */
		/*   #      */
		/*   # #### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x2f,
		0x20,
		0x2f,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 205 9552 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*          */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x00,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 206 9580 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ### #### */
		/*          */
		/* ### #### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xef,
		0x00,
		0xef,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 207 9575 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ######## */
		/*          */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xff,
		0x00,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 208 9576 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 209 9572 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*          */
		/* ######## */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x00,
		0xff,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 210 9573 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 211 9561 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   ###### */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x3f,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 212 9560 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    ##### */
		/*    #     */
		/*    ##### */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x1f,
		0x10,
		0x1f,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 213 9554 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##### */
		/*    #     */
		/*    ##### */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x1f,
		0x10,
		0x1f,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 214 9555 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###### */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3f,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 215 9579 */
	{
		/*          */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/* ######## */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*   # #    */
		/*          */
		0x00,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0xff,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x28,
		0x00,
	},
	/* 216 9578 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ######## */
		/*    #     */
		/* ######## */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xff,
		0x10,
		0xff,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 217 9496 */
	{
		/*          */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/* ####     */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0xf0,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 218 9484 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##### */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x1f,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x00,
	},
	/* 219 9608 */
	{
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		0x00,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0x00,
	},
	/* 220 9604 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0x00,
	},
	/* 221 9612 */
	{
		/*          */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/* ####     */
		/*          */
		0x00,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0xf0,
		0x00,
	},
	/* 222 9616 */
	{
		/*          */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*     #### */
		/*          */
		0x00,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x0f,
		0x00,
	},
	/* 223 9600 */
	{
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 224 945 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #### #  */
		/*  #  # #  */
		/* ##   #   */
		/* ##   #   */
		/*  #   #   */
		/*  #  ##   */
		/*  #### #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7a,
		0x4a,
		0xc4,
		0xc4,
		0x44,
		0x4c,
		0x7a,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 225 223 */
	{
		/*          */
		/*          */
		/*   ###    */
		/*  #   #   */
		/*  #   #   */
		/*  #  #    */
		/*  # #     */
		/*  # #     */
		/*  # ###   */
		/*  #   ##  */
		/*  #    #  */
		/*  #    #  */
		/*  # ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x38,
		0x44,
		0x44,
		0x48,
		0x50,
		0x50,
		0x5c,
		0x46,
		0x42,
		0x42,
		0x5c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 226 915 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*  #       */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x40,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 227 960 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*  ##  #   */
		/*  ##  #   */
		/*  ##  #   */
		/*  ##  #   */
		/*  ##  #   */
		/*  ##  ### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x64,
		0x64,
		0x64,
		0x64,
		0x64,
		0x67,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 228 931 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ####### */
		/*  ##      */
		/*   ##     */
		/*    #     */
		/*     #    */
		/*    #     */
		/*   ##     */
		/*  ##      */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x7f,
		0x60,
		0x30,
		0x10,
		0x08,
		0x10,
		0x30,
		0x60,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 229 963 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  ##  #   */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x64,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 230 181 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #   ##  */
		/*  ####### */
		/*  #       */
		/*  #       */
		/*  #       */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x46,
		0x7f,
		0x40,
		0x40,
		0x40,
		0x00,
	},
	/* 231 964 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  #####   */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*     ##   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7c,
		0x10,
		0x10,
		0x10,
		0x10,
		0x10,
		0x0c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 232 934 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###    */
		/*    #     */
		/*  #####   */
		/* #  #  #  */
		/* #  #  #  */
		/* #  #  #  */
		/*  #####   */
		/*    #     */
		/*   ###    */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x38,
		0x10,
		0x7c,
		0x92,
		0x92,
		0x92,
		0x7c,
		0x10,
		0x38,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 233 920 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  # ### # */
		/*  #     # */
		/*  #     # */
		/*   #   #  */
		/*    ###   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x5d,
		0x41,
		0x41,
		0x22,
		0x1c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 234 937 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ###   */
		/*   #   #  */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  #     # */
		/*  ##   ## */
		/*   #   #  */
		/*  ### ### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x1c,
		0x22,
		0x41,
		0x41,
		0x41,
		0x41,
		0x63,
		0x22,
		0x77,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 235 948 */
	{
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  ##      */
		/*  ##      */
		/*   ####   */
		/*  ##  ##  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  ##  ##  */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x3c,
		0x60,
		0x60,
		0x3c,
		0x66,
		0x42,
		0x42,
		0x42,
		0x66,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 236 8734 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ## ##   */
		/* # ##  #  */
		/* #  #  #  */
		/* # ##  #  */
		/*  ## ##   */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x6c,
		0xb2,
		0x92,
		0xb2,
		0x6c,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 237 966 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   #####  */
		/*  ## # ## */
		/*  #  #  # */
		/*  #  #  # */
		/*  #  #  # */
		/*  ## # ## */
		/*   #####  */
		/*     #    */
		/*     #    */
		/*     #    */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3e,
		0x6b,
		0x49,
		0x49,
		0x49,
		0x6b,
		0x3e,
		0x08,
		0x08,
		0x08,
		0x00,
	},
	/* 238 949 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*  #       */
		/*  #       */
		/*   ###    */
		/*  #       */
		/*  #       */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x40,
		0x40,
		0x38,
		0x40,
		0x40,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 239 8745 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*   ####   */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*  #    #  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x3c,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x42,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 240 8801 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ######  */
		/*          */
		/*  ######  */
		/*          */
		/*          */
		/*  ######  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x7e,
		0x00,
		0x7e,
		0x00,
		0x00,
		0x7e,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 241 177 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    #     */
		/*    #     */
		/* #######  */
		/*    #     */
		/*    #     */
		/*          */
		/* #######  */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x10,
		0x10,
		0xfe,
		0x10,
		0x10,
		0x00,
		0xfe,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 242 8805 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*  ##      */
		/*   ####   */
		/*       ## */
		/*    ###   */
		/*  ##      */
		/*          */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x60,
		0x3c,
		0x03,
		0x1c,
		0x60,
		0x00,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 243 8804 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*       ## */
		/*    ####  */
		/*  ##      */
		/*    ###   */
		/*       ## */
		/*          */
		/*  ####### */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x03,
		0x1e,
		0x60,
		0x1c,
		0x03,
		0x00,
		0x7f,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 244 8992 */
	{
		/*          */
		/*     ###  */
		/*     # #  */
		/*     #    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*          */
		0x00,
		0x0e,
		0x0a,
		0x08,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x00,
	},
	/* 245 8993 */
	{
		/*          */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    ##    */
		/*    #     */
		/*    #     */
		/*    #     */
		/*    #     */
		/*  # #     */
		/*  ##      */
		/*          */
		0x00,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x18,
		0x10,
		0x10,
		0x10,
		0x10,
		0x50,
		0x60,
		0x00,
	},
	/* 246 247 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/* ######## */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0xff,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 247 8776 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ###  # */
		/*  #   ### */
		/*   ###  # */
		/*  #   ##  */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x39,
		0x47,
		0x39,
		0x46,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 248 176 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   #  #   */
		/*   #  #   */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x24,
		0x24,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 249 8729 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*   ####   */
		/*   ####   */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x3c,
		0x3c,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 250 183 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*    ##    */
		/*    ##    */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x18,
		0x18,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 251 8730 */
	{
		/*          */
		/*          */
		/*       #  */
		/*       #  */
		/*      #   */
		/*      #   */
		/*      #   */
		/* ##  #    */
		/*   # #    */
		/*   # #    */
		/*   ##     */
		/*    #     */
		/*    #     */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x02,
		0x02,
		0x04,
		0x04,
		0x04,
		0xc8,
		0x28,
		0x28,
		0x30,
		0x10,
		0x10,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 252 8319 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*   #  #   */
		/*   #  #   */
		/*   #  #   */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x24,
		0x24,
		0x24,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 253 178 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*   ####   */
		/*      #   */
		/*     #    */
		/*    #     */
		/*   ####   */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x3c,
		0x04,
		0x08,
		0x10,
		0x3c,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
	/* 254 9632 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/* ######## */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0xff,
		0x00,
		0x00,
		0x00,
	},
	/* 255 32 */
	{
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		/*          */
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
	},
};
