/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MultiBind<C, K, V>
extends HashMap<C, Map<K, V>> {
    public void put(C category, K key, V value) {
        this.getOrCreateCategory(category).put(key, value);
    }

    public V getValue(C category, K key) {
        Map<K, V> cat = this.getCategory(category);
        if (cat == null) {
            return null;
        }
        return cat.get(key);
    }

    public Map<K, V> getCategory(C category) {
        return Collections.unmodifiableMap((Map)this.get(category));
    }

    public boolean categoryExists(C category) {
        return this.containsKey(category) && ((Map)this.get(category)).size() > 0;
    }

    public boolean keyExists(C category, K key) {
        Map<K, V> cat = this.getCategory(category);
        return cat != null && cat.containsKey(key);
    }

    private Map<K, V> getOrCreateCategory(C category) {
        Map<K, V> cat = this.getCategory(category);
        if (cat == null) {
            cat = new HashMap();
            this.put(category, cat);
        }
        return cat;
    }
}

