/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.core.java;

public class MemBuffer {
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private byte[] buffer = null;

    public void allocate(int size) {
        if (this.isAllocated()) {
            throw new IllegalStateException("Memory buffer already in use.");
        }
        this.buffer = new byte[size];
    }

    public void allocate() {
        this.allocate(1000000);
    }

    public void deallocate() {
        this.buffer = null;
    }

    public void free() {
        this.deallocate();
        System.gc();
    }

    public void reset(int size) {
        this.free();
        this.allocate(size);
    }

    public void reset() {
        this.reset(1000000);
    }

    public void resetQuick(int size) {
        this.deallocate();
        this.allocate(size);
    }

    public void resetQuick() {
        this.resetQuick(1000000);
    }

    public boolean isAllocated() {
        return this.buffer != null;
    }

    public int getBufferSize() {
        return this.buffer == null ? 0 : this.buffer.length;
    }

    public byte getByte(int memPosition) {
        if (this.buffer == null) {
            throw new IllegalStateException("Access to empty memory buffer");
        }
        return this.buffer[memPosition % this.buffer.length];
    }
}

