/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.FileParser;
import net.acomputerdog.OBFUtil.parse.FormatException;
import net.acomputerdog.OBFUtil.table.OBFTable;
import net.acomputerdog.core.java.Patterns;

public class SRGFileParser
extends FileParser {
    private final String side;
    private final boolean stripDescs;

    public SRGFileParser(String side, boolean stripMethodDescriptors) {
        this.side = side;
        this.stripDescs = stripMethodDescriptors;
    }

    @Override
    protected void parseFile(BufferedReader reader, OBFTable table, boolean overwrite) throws IOException {
        String str;
        int line = 0;
        while ((str = reader.readLine()) != null) {
            String side;
            String deobf;
            String obf;
            ++line;
            String[] sections = str.split(Patterns.SPACE);
            if (sections.length < 3) {
                throw new FormatException("Not enough sections on line " + line + ": \"" + str + "\"");
            }
            TargetType type = TargetType.getType(sections[0].replace(":", ""));
            if (type == null) {
                throw new FormatException("Illegal target type on line " + line + ": \"" + sections[0] + "\"");
            }
            if (type == TargetType.METHOD) {
                if (sections.length < 5) {
                    throw new FormatException("Not enough sections on line " + line + ": \"" + str + "\"");
                }
                if (this.stripDescs) {
                    obf = sections[1].replace('/', '.');
                    deobf = sections[3].replace('/', '.');
                } else {
                    obf = sections[1].replace('/', '.').concat(" ").concat(sections[2].replace('.', '/'));
                    deobf = sections[3].replace('/', '.').concat(" ").concat(sections[4].replace('.', '/'));
                }
                side = sections.length >= 6 ? sections[5].replace("#", "") : "";
            } else {
                obf = sections[1].replace('/', '.');
                deobf = sections[2].replace('/', '.');
                String string = side = sections.length >= 4 ? sections[3].replace("#", "") : "";
            }
            if (!overwrite && table.hasDeobf(obf, type) || !side.isEmpty() && !this.side.isEmpty() && !side.equals(this.side)) continue;
            table.addType(obf, deobf, type);
        }
    }

    @Override
    public void storeEntries(File file, OBFTable table) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        try (Writer out = null;){
            out = new BufferedWriter(new FileWriter(file));
            TargetType[] targetTypeArray = TargetType.parsable();
            int n = targetTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetType type = targetTypeArray[n2];
                if (table.supportsType(type)) {
                    String[] stringArray = table.getAllObf(type);
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String obf = stringArray[n4];
                        String deobf = table.deobf(obf, type);
                        out.write(this.getPrefix(type));
                        out.write(": ");
                        out.write(type == TargetType.PACKAGE && obf.length() == 1 ? obf : this.slash(obf));
                        out.write(" ");
                        out.write(type == TargetType.PACKAGE && deobf.length() == 1 ? deobf : this.slash(deobf));
                        if (this.side.length() > 0) {
                            out.write(" #");
                            out.write(this.side);
                        }
                        out.write(Patterns.LINE_SEPARATOR);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private String slash(String s) {
        return s.replace('.', '/');
    }

    private String getPrefix(TargetType type) {
        switch (type) {
            case PACKAGE: {
                return "PK";
            }
            case CLASS: {
                return "CL";
            }
            case METHOD: {
                return "MD";
            }
            case FIELD: {
                return "FD";
            }
        }
        throw new IllegalArgumentException("Invalid TargetType: " + type.name());
    }
}

