/*
 * Decompiled with CFR 0.152.
 */
package net.acomputerdog.OBFUtil.parse.types;

import java.io.File;
import java.io.IOException;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.FileParser;
import net.acomputerdog.OBFUtil.parse.types.CSVFileParser;
import net.acomputerdog.OBFUtil.table.DirectOBFTable;
import net.acomputerdog.OBFUtil.table.OBFTable;

public class MCPCSVFileParser
extends CSVFileParser {
    private static final int OBFNAME_INDEX = 0;
    private static final int DEOBFNAME_INDEX = 1;
    private static final int SIDE_INDEX = 2;
    private final TargetType type;
    private final Side side;

    public MCPCSVFileParser(TargetType type) {
        this(type, Side.NONE);
    }

    public MCPCSVFileParser(TargetType type, Side side) {
        this.type = type;
        this.side = side;
    }

    @Override
    public void writeCSVToTable(File source, CSVFileParser.CSVFile csv, OBFTable table) {
        int rowNum = 0;
        while (rowNum < csv.size()) {
            String[] row = csv.getRow(rowNum);
            if (this.side == Side.NONE || Side.fromStringIndex(row[2]).equals(this.side)) {
                table.addType(row[0], row[1], this.type);
            }
            ++rowNum;
        }
    }

    @Override
    public CSVFileParser.CSVFile readCSVFromTable(File source, OBFTable table) {
        String[] obfs;
        CSVFileParser.CSVFile csv = new CSVFileParser.CSVFile();
        String[] stringArray = obfs = table.getAllObf(this.type);
        int n = obfs.length;
        int n2 = 0;
        while (n2 < n) {
            String obf = stringArray[n2];
            csv.addItem("searge", obf);
            csv.addItem("name", table.deobf(obf, this.type));
            csv.addItem("side", String.valueOf(this.side.side));
            csv.addItem("desc", "");
            ++n2;
        }
        return csv;
    }

    public static void main(String[] args) {
        File csvFile;
        if (args.length < 1) {
            System.out.println("No file specified!  Use \"test <path_to_csv>\"");
            System.exit(0);
        }
        if (!(csvFile = new File(args[0])).exists() || !csvFile.isFile()) {
            System.out.println("Path does not represent a file!  Use \"test <path_to_csv>\"");
            System.exit(0);
        }
        MCPCSVFileParser parser = new MCPCSVFileParser(MCPCSVFileParser.getTypeOfFile(csvFile), Side.CLIENT);
        DirectOBFTable table = new DirectOBFTable();
        try {
            ((FileParser)parser).loadEntries(csvFile, table, true);
        }
        catch (IOException e) {
            System.out.println("Exception parsing CSV!");
            e.printStackTrace();
            System.exit(-1);
        }
        TargetType[] targetTypeArray = TargetType.parsable();
        int n = targetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TargetType i = targetTypeArray[n2];
            if (table.supportsType(i)) {
                System.out.println(String.valueOf(i.name()) + ":");
                String[] stringArray = table.getAllObf(i);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String str = stringArray[n4];
                    System.out.println("   " + str + " = " + table.deobf(str, i));
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static TargetType getTypeOfFile(File f) {
        String n = f.getName();
        if (n.startsWith("fields")) {
            return TargetType.FIELD;
        }
        if (n.startsWith("methods")) {
            return TargetType.METHOD;
        }
        throw new IllegalArgumentException("File is not a valid MCP CSV file!");
    }

    public static enum Side {
        NONE(-1),
        CLIENT(0),
        BOTH(1),
        SERVER(2);

        private final int side;

        private Side(int side) {
            this.side = side;
        }

        public static Side fromStringIndex(String side) {
            return Side.valueOf(Integer.valueOf(side));
        }

        public boolean matches(int side) {
            return side == 2 || this.side == side;
        }

        public boolean equals(Side other) {
            return this.matches(other.side);
        }

        public static Side valueOf(String string) {
            return Enum.valueOf(Side.class, string);
        }
    }
}

