/*
 * Decompiled with CFR 0.152.
 */
package com.blazeloader.jarjar.convert;

import com.blazeloader.jarjar.tree.ClassMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.acomputerdog.OBFUtil.map.TargetType;
import net.acomputerdog.OBFUtil.parse.types.SRGFileParser;
import net.acomputerdog.OBFUtil.table.DirectOBFTable;
import net.acomputerdog.core.java.Patterns;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class SeargToEnigmaConverter {
    private static final Pattern DESCRIPTOR_MATCHER = Pattern.compile("\\[*L[^;]+;|\\[[ZBCSIFDJ]|[ZBCSIFDJ]");
    private ClassMap classes = new ClassMap();
    private DirectOBFTable table = new DirectOBFTable();
    private SRGFileParser seargeParser;

    public SeargToEnigmaConverter(boolean side, File seargeFile, File jarFile) {
        this.seargeParser = new SRGFileParser(side ? "C" : "S", false);
        try {
            this.classes.readFromJar(jarFile);
            this.seargeParser.loadEntries(seargeFile, this.table, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String fieldType(String className, String memberName) {
        if (this.classes.containsKey(className)) {
            ClassNode node = (ClassNode)this.classes.get(className);
            for (FieldNode i : node.fields) {
                if (!i.name.equals(memberName)) continue;
                return i.desc;
            }
            return null;
        }
        return null;
    }

    public void storeEntries(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        try (Writer out = null;){
            out = new BufferedWriter(new FileWriter(file));
            System.out.println("Strip generics: Because enigma doesn't support those. -_-;");
            String[] classes = this.table.getAllObf(TargetType.CLASS);
            String[] methods = this.table.getAllObf(TargetType.METHOD);
            String[] fields = this.table.getAllObf(TargetType.FIELD);
            String[] stringArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                if (i.indexOf("$") == -1) {
                    this.writeClass(out, "", i, classes, methods, fields);
                }
                ++n2;
            }
        }
    }

    private String stripGenerics(String in) {
        return in.replaceAll("([^<]*)[^>]*>*([^>]*)", "$1$2");
    }

    private void writeClass(Writer out, String indent, String className, String[] classes, String[] methods, String[] fields) throws IOException {
        String[] name;
        String deobfClass = this.table.deobf(className, TargetType.CLASS);
        int dollar = deobfClass.lastIndexOf("$");
        String dumpedClass = dollar >= 0 ? deobfClass.substring(dollar + 1, deobfClass.length()) : deobfClass;
        dollar = dumpedClass.lastIndexOf("\\.");
        if (dollar != -1) {
            dumpedClass = dumpedClass.substring(dollar + 1, deobfClass.length());
        }
        out.write(String.valueOf(indent) + "CLASS ");
        String obfDumpedClassName = className.replace('.', '/');
        if (obfDumpedClassName.indexOf(47) == -1) {
            out.write("none/");
        }
        out.write(obfDumpedClassName);
        if (!Character.isDigit(dumpedClass.charAt(0))) {
            if (dumpedClass.indexOf(46) == -1) {
                if (indent.isEmpty()) {
                    dumpedClass = "none/" + dumpedClass;
                }
            } else {
                dumpedClass = dumpedClass.replace('.', '/');
            }
            out.write(" ".concat(dumpedClass));
        }
        out.write(Patterns.LINE_SEPARATOR);
        String prefix = String.valueOf(className) + ".";
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String clazz = stringArray[n2];
            if (clazz.indexOf(String.valueOf(className) + "$") == 0) {
                this.writeClass(out, String.valueOf(indent) + "\t", clazz, classes, methods, fields);
            }
            ++n2;
        }
        stringArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (field.indexOf(prefix) == 0) {
                name = field.replace(prefix, "");
                String type = this.fieldType(obfDumpedClassName, (String)name);
                String deobf = this.table.deobf(field, TargetType.FIELD).replace(String.valueOf(deobfClass) + ".", "");
                if (name.indexOf(36) == -1 && deobf.indexOf(36) == -1) {
                    if (type != null) {
                        if (deobf.indexOf("field_") != 0) {
                            out.write(String.valueOf(indent) + "\tFIELD " + (String)name + " " + deobf + " " + this.insertNullPackage(this.stripGenerics(type)) + Patterns.LINE_SEPARATOR);
                        }
                    } else {
                        System.out.println("Error: No signature information for field " + deobf + " in class " + deobfClass);
                    }
                }
            }
            ++n2;
        }
        stringArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            if (method.indexOf(prefix) == 0) {
                name = method.replace(prefix, "").split(" ");
                String deobf = this.table.deobf(method, TargetType.METHOD).split(" ")[0].replace(String.valueOf(deobfClass) + ".", "");
                if (name[0].indexOf(36) == -1 && deobf.indexOf(36) == -1 && deobf.indexOf("func_") != 0) {
                    out.write(String.valueOf(indent) + "\tMETHOD " + name[0] + " " + deobf + " " + this.insertNullPackages(this.stripGenerics(name[1])) + Patterns.LINE_SEPARATOR);
                }
            }
            ++n2;
        }
    }

    private String insertNullPackages(String descriptor) {
        String obfuscatedDescriptor = "";
        String[] split = descriptor.split("\\)");
        List<String> paramaters = this.splitDescriptor(split[0]);
        if (split.length < 2) {
            throw new IllegalArgumentException("Missing return type for \"" + descriptor + "\"");
        }
        for (String i : paramaters) {
            obfuscatedDescriptor = String.valueOf(obfuscatedDescriptor) + this.insertNullPackage(i);
        }
        return "(" + obfuscatedDescriptor + ")" + this.insertNullPackage(split[1]);
    }

    private String insertNullPackage(String type) {
        if (type.endsWith(";") && type.indexOf(47) == -1) {
            String clazz = this.extractClass(type);
            return type.replace(clazz, "none/" + clazz);
        }
        return type;
    }

    private List<String> splitDescriptor(String descriptor) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = DESCRIPTOR_MATCHER.matcher(descriptor.trim());
        while (matcher.find()) {
            params.add(matcher.group());
        }
        return params;
    }

    private String extractClass(String descriptedClass) {
        String[] split = descriptedClass.split("\\[");
        String result = split[split.length - 1];
        return result.substring(1, result.length() - 1);
    }
}

